#ifndef H_cOperator
#define H_cOperator

const int MAX_CODE_BYTES = 6;

enum eOperandType{
	OP_ERROR, OP_VOID, OP_SREG, 
	OP_REG, OP_REG8, OP_REG16, 
	OP_MEM, OP_MEM8, OP_MEM16, 
	OP_IMM, OP_IMM8, OP_IMM16,
	OP_LABEL8, OP_LABEL16
};

struct sOpCodeInfo{
	int reg, sreg;
	int imm, disp;
	int mod, rm;
	bool w, s;
};

class cOpCode{
protected:
	eOperandType Operand1, Operand2;
	char Code1[8], Code2[8];
	int StaticSize;
public:
	cOpCode();
	cOpCode(cOpCode &A);
	bool Set(eOperandType Type1, eOperandType Type2, char *nCode1, char *nCode2);
	void Get(eOperandType &Type1, eOperandType &Type2, char *nCode1, char *nCode2, int &nStaticSize);
	void GetSizeInfo(eOperandType &Type1, eOperandType &Type2, int &StaticSize);
	void GetType(eOperandType &Type1, eOperandType &Type2);
	void GetCode(char *nCode1, char *nCode2);

};

class cOperator{
protected:
	char Name[8];
	int SortCount;
	cOpCode *OpCode;

public:
	cOperator();
	cOperator(cOperator &A);

	bool Create(char *Name, int n);
	void Destroy();

	void SetName(char *nName);
	void GetName(char *nName);
	int GetSortCount();

	bool SetOpCode(int n, char *Operand1, char *Operand2, char *Code1, char *Code2);
	void GetOpCode(int n, eOperandType &Type1, eOperandType &Type2, char *nCode1, char *nCode2, int &nStaticSize);
	void GetOpCodeSizeInfo(int n, eOperandType &Type1, eOperandType &Type2, int &nStaticSize);

	eOperandType GetOperandType(char *Operand);
	// For Hash Table
	int GetHashNumber();
	void operator=(cOperator &A);
	bool operator==(cOperator &A);
};

#endif