;-----------------------------;
; View file attribute utility ;
; Written by Heedong, Lim.    ;
;-----------------------------;

CmdLine: equ 0x80

  org  0x100

  movw  si,CmdLine
  movb  bl,[si]
  testb bl,bl
  jnz    CheckFile

  movw  dx,HelpMsg
  calln PrintMsg
  jmps  Exit

CheckFile:
  xorb  bh,bh
  incw  si
  movb  [bx+si],0
  movw  ax,0x4300
  movw  dx,si
  incw  dx
  int   0x21
  jnc   ReadOnlyCheck

  movw  dx,ErrMsg
  calln PrintMsg
  jmps  Exit

ReadOnlyCheck:
  testw cx,1
  jz    ReadWriteFile
  movw  dx,ReadOnlyMsg
  calln PrintMsg
  jmps  HiddenCheck

ReadWriteFile:
  movw  dx,ReadWriteMsg
  calln PrintMsg

HiddenCheck:
  testw cx,2
  jz    SysCheck
  movw  dx,HiddenMsg
  calln PrintMsg

SysCheck:
  testw cx,4
  jz    CheckEnd
  movw  dx,SysMsg
  calln PrintMsg

CheckEnd:
  movw  dx,FileMsg
  calln PrintMsg

Exit:
  int   0x20 ; Return to DOS

PrintMsg: ; Print message subroutine
  movb  ah,9
  int   0x21
  retn

HelpMsg:      ds "Usage: viewattr filename$"
ErrMsg:       ds "File open error.$"
ReadWriteMsg: ds "Read/Write $"
ReadOnlyMsg:  ds "Read only $"
HiddenMsg:    ds "Hidden $"
SysMsg:       ds "System $"
FileMsg:      ds "file.$"
