CmdLine: equ 0x80
	org   0x100
	
	mov	si, CmdLine
	mov	bl, [si]
	test	bl,bl ; Check command line argument
	jnz    OpenFile
	
	mov	dx, HelpMsg
	call	near PrintMsg ; Display help message
	jmp	short Exit

OpenFile:
	xor	bh, bh
	inc	si
	mov	[bx+si], 0
	mov	ah, 0x3D
	mov	dx, si
	inc	dx
	int	0x21
	mov	[Handle], ax
	jnc	ReadFile

	mov	dx, ErrMsg
	call	near PrintMsg
	jmp	short Exit

ReadFile:
	mov	bx, [Handle]
	mov	dx, Buff
	mov	cx, 1
	mov	ah, 0x3F
	int	0x21
	cmp	ax, 0 ; No more data
	je	Exit

	mov	dl, [Buff]
	call	near PrintChar
	jmp	short  ReadFile

Exit:
	mov	ah, 0x3E
	mov	bx, [Handle]
	int	0x21
	int	0x20 ; Return to DOS

PrintMsg: ; Print message subroutine, dx: message address
	mov	ah, 9
	int	0x21
	ret

PrintChar: ; Print character subroutine, dl: character
	mov	ah, 2
	int	0x21
	ret

Handle:		dw 0
Buff:		db 0
HelpMsg:	ds "usage: viewfile file-name\xd\xa$"
ErrMsg:		ds "File open error!\xd\xa$"
