// cActiveObjectList.cpp: implementation of the cActiveObjectList class.
//
//////////////////////////////////////////////////////////////////////

#include "cActiveObjectList.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template<class cObject>
cActiveObjectList<cObject>::cActiveObjectList(){
	pFocus = NULL;
}

template<class cObject>
cActiveObjectList<cObject>::~cActiveObjectList(){

}

template<class cObject>
void cActiveObjectList<cObject>::SetFocus(iterator it){
	pFocus = *it;
}

template<class cObject>
int cActiveObjectList<cObject>::Act(){
	iterator it;

	for(it = begin(); it != end();){
		if((*it)->Act() == -1){
			it = erase(it);
		}else{
			it ++;
		}
	}
	return 0;
}

template<class cObject>
void cActiveObjectList<cObject>::DeleteAll(BOOL bDelete){
	cObject *pObject;
	iterator it;

	if(!bDelete){
		clear();
		return;
	}

	it = begin();
	while(it != end()){
		pObject = *it;
		it = erase(it);
		delete pObject;
	}
}

template<class cObject>
void cActiveObjectList<cObject>::Delete(iterator it){
	delete (*it);
	erase(it);
}

