// cActiveObjectList.h: interface for the cActiveObjectList class.
//
//////////////////////////////////////////////////////////////////////

#ifndef cActiveObjectList_H
#define cActiveObjectList_H

#include <list>
#include <windows.h>
#include "cActiveObject.h"

template<class cObject>
class cActiveObjectList : 
public std::list<cObject *>,
public cActiveObject{
protected:
	cObject *pFocus;

public:
	cActiveObjectList();
	virtual ~cActiveObjectList();

	void Delete(iterator it);
	void DeleteAll(BOOL bDelete);

	virtual int Act();

	void SetFocus(iterator it);
	cObject *GetFocus(){ return pFocus; }


};

#endif
