// cAppWindow.cpp: implementation of the cAppWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "cAppWindow.h"

template <class cWinApp>
bool cAppWindow<cWinApp>::ClassRegistered = false;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template <class cWinApp>
cAppWindow<cWinApp>::cAppWindow(){

}

template <class cWinApp>
cAppWindow<cWinApp>::~cAppWindow(){

}

//////////////////////////////////////////////////////////////////////
// Window Class Register / Create Window Extended
//////////////////////////////////////////////////////////////////////
template <class cWinApp>
bool cAppWindow<cWinApp>::RegisterClass(HINSTANCE hInstance){
	WNDCLASSEX wc;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW; 
	wc.lpfnWndProc = DefaultWindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0; 
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APP));
	wc.hCursor = LoadCursor(hInstance, MAKEINTRESOURCE(IDC_AS));
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = GetClassName();
	wc.hIconSm = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPLICATION)); 

	if(!RegisterClassEx(&wc))
		return false;

	ClassRegistered = true;
	return true;
}

template <class cWinApp>
bool cAppWindow<cWinApp>::Create(){
	return cWindow::Create(
		WS_EX_APPWINDOW, // Extended Window Style
		pWinApp->GetAppTitle(), // Caption
		WS_OVERLAPPEDWINDOW | WS_VISIBLE, // Window Style
		CW_USEDEFAULT, CW_USEDEFAULT, // x, y
		CW_USEDEFAULT, CW_USEDEFAULT, // Width, Height
		NULL, // Parent Window
		NULL, // Menu
		*pWinApp, // hInstance
		NULL); 
}

template <class cWinApp>
LRESULT cAppWindow<cWinApp>::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return cWindow::WindowProc(uMsg, wParam, lParam);
}
