// cArray.cpp: implementation of the cArray class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "cArray.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template<class Type>
cArray<Type>::cArray(){
	Elements = NULL;
}

template<class Type>
cArray<Type>::~cArray(){
//	Destroy();
	if(Elements) delete [] Elements;
}

template<class Type>
BOOL cArray<Type>::Create(int Size){
	Destroy();
	Elements = new Type[Size];
	ElementCount = Size;

	return Elements != NULL;
}

template<class Type>
void cArray<Type>::Destroy(){
	if(Elements) delete [] Elements;
	Elements = NULL;
}


template<class Type>
BOOL cArray<Type>::Load(cMedium *pMedium){
	int i, Count;

	pMedium->Read(&Count, sizeof(int));
	if(Elements){ // ޸𸮰 Ҵ 
		if(Count > ElementCount) return FALSE;
	}else{ // ޸𸮰 Ҵ  
		//  ޸𸮸 ҴѴ.
		if(!Create(Count)) return FALSE;
	}
	// ޸𸮷 ͸ оδ.
	for(i = 0; i < Count; i ++)
		Elements[i].Load(pMedium);

	return TRUE;
}

template<class Type>
BOOL cArray<Type>::Save(cMedium *pMedium){
	if(!Elements) return FALSE;
	pMedium->Write(&ElementCount, sizeof(int));
	for(int i = 0; i < ElementCount; i ++)
		Elements[i].Save(pMedium);
	return TRUE;
}


