// cArray.h: interface for the cArray class.
//
//////////////////////////////////////////////////////////////////////

#ifndef cArray_H
#define cArray_H

#include "cRecorder.h"

template<class Type>
class cArray : 
public cRecorder{
protected:
	Type *Elements;
	int ElementCount;

public:
	cArray();
	virtual ~cArray();

	BOOL Create(int Size);
	virtual void Destroy();

	virtual BOOL Load(cMedium *pMedium);
	virtual BOOL Save(cMedium *pMedium);

	int GetCount(){ return ElementCount; }
	Type &operator[](int Index){ return Elements[Index]; }

};

#endif
