// cArray2D.cpp: implementation of the cArray2D class.
//
//////////////////////////////////////////////////////////////////////

#include "cArray2D.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template<class Type> 
cArray2D<Type>::cArray2D(){
	Elements = NULL;
}

template<class Type>
cArray2D<Type>::~cArray2D(){
	Destroy();
}

template<class Type>
bool cArray2D<Type>::Create(int _Height, int _Width, bool Clear){
	Width = _Width;
	Height = _Height;

	cArray2D<Type>::Destroy();
	Elements = new Type [ Width * Height ];
	if(!Elements) return false;

	return true;
}

template<class Type>
void cArray2D<Type>::Destroy(){
	if(Elements){
		delete [] Elements;
		Elements = NULL;
	}
}


