#include "TOOLType.h"
#include "cArray3D.h"

template <class T> cArray3D<T>::cArray3D(){
	Element = null;
}

template <class T> cArray3D<T>::~cArray3D(){
	Destroy();
}

template <class T> void cArray3D<T>::Destroy(){
	if(Element) delete [] Element;
	Element = null;
}

template <class T> bool cArray3D<T>::Create(int z, int y, int x){
	Destroy(); // 迭 Ǿ Ȯ

	xSize = x; 
	ySize = y; 
	zSize = z;

	yPitch = xSize; 
	zPitch = xSize * ySize;

	Element = new T[x * y * z];

	return Element != null;
}

template <class T> void cArray3D<T>::Set(int z, int y, int x, T &Data){
	Element[z * zPitch + y * yPitch + x] = Data;
}


template <class T> void cArray3D<T>::Get(int z, int y, int x, T &Data){
	Data = Element[z * zPitch + y * yPitch + x];
}

template <class T> T *cArray3D<T>::GetPtr(int z, int y, int x){
	return &Element[z * zPitch + y * yPitch + x];
}
