// cDialog.cpp: implementation of the cDialog class.
//
//////////////////////////////////////////////////////////////////////

#include "cDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cDialog::cDialog(){
}

cDialog::~cDialog(){

}

//////////////////////////////////////////////////////////////////////
// Modal Dialog Message Loop
//////////////////////////////////////////////////////////////////////

void cDialog::End(int Result){
	ReturnValue = Result;
	MessageLooping = false;
}

int cDialog::MessageLoop(){
	// ̾ α ޽  .
	MSG msg;
	// ̾α  ȿ ִ ޽ ޾Ƶδ.
	while(GetMessage(&msg, NULL, 0, 0)){
		if(!IsDialogMessage(&msg)){
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if(!MessageLooping) break;
	}
	return 1;
}


int cDialog::DoModal(cWindow *_pParent){
	cWindow *pOwner; // ̾α׸   

	// Disable Owner Root
	// θ  Ʈ 츦 ã  Ұϰ .
	if(_pParent){
		pOwner = _pParent->GetTopLevelParent();
		pOwner->Enable(FALSE);
	}

	Create(_pParent);
	Show(SW_SHOW);
	Update();

	MessageLooping = true;
	ReturnValue = -1;

	MessageLoop();

	// Enable Owner Root
	if(pOwner) pOwner->Enable(TRUE);
	if(_pParent) _pParent->SetFocus();

	Destroy();

	return ReturnValue;
}

LRESULT cDialog::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case IDOK:
		case IDCANCEL:
		case IDABORT:
			End(LOWORD(wParam));
			return 0;
		}
		break;
	}
	return DefProc(uMsg, wParam, lParam);
}
