#ifndef H_cFile
#define H_cFile

#include <stdio.h>
#include "cStack.h"

class cFile{
protected:
	char	*FileName;
	FILE	*File;
	cStack<fpos_t>	PosStack;
public:
	cFile();
	~cFile();

	bool Open(char *Mode);
	bool Open(char *FileName, char *Mode);
	void Close();

	FILE *GetFile();

	int	Read(void *Dest, int Size, int Block = 1);
	int Write(void *Src, int Size, int Block = 1);
	int WriteSpace(int Count);

	char *Gets(char *String, int n);
	int Puts(char *String);
	int Printf(char *Format, ...);

	int Getc();
	int Putc(int c);
	bool GetString(char *Buffer, int n);
	int Ungetc(int Char);

	bool Seek(int Offset, int Origin);
	bool SkipSpace();
	bool FindChar(char c);

	// File Position Management
	void ClearPosStack();
	bool PushPos();
	bool PopPos();
	void DelTop();

	void SetFileName(char *nFileName); // Set File Name
};

#endif