// cGameCreateDlg.cpp: implementation of the cGameCreateDlg class.
//
//////////////////////////////////////////////////////////////////////

#include "cGameCreateDlg.h"
#include "TOOLMemory.h"

BOOL cGameCreateDlg::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cGameCreateDlg::cGameCreateDlg(){
}

cGameCreateDlg::~cGameCreateDlg(){
	cDialog::~cDialog();
}

//////////////////////////////////////////////////////////////////////
// Window Class Register / Create Window Extended
//////////////////////////////////////////////////////////////////////
BOOL cGameCreateDlg::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW)),
		HBRUSH(COLOR_BTNFACE + 1));
	return ClassRegistered;
}

BOOL cGameCreateDlg::Create(cWindow *_pParent){
	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		"ο  ", // Caption
		WS_POPUPWINDOW | WS_CAPTION | WS_VISIBLE,
		CW_USEDEFAULT, CW_USEDEFAULT, // x, y
		400, 240, // Width, Height
		_pParent, // Parent Window
		NULL); // Menu
}

int cGameCreateDlg::DoModal(cWindow *_pParent, cGameInfo *_pGameInfo){
	pGameInfo = _pGameInfo;

	return cDialog::DoModal(_pParent);
}

//////////////////////////////////////////////////////////////////////
// Window Procedure
//////////////////////////////////////////////////////////////////////

LRESULT cGameCreateDlg::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		OnCreate(lParam);
		return 0;
	case WM_DESTROY:
		OnDestroy();
		return 0;
	case WM_PAINT:
		OnPaint(wParam, lParam);
		return 0;
	case WM_COMMAND:
		if(OnCommand(wParam, lParam)) break;
		return 0;
	}
	return cDialog::Proc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////

void cGameCreateDlg::OnPaint(WPARAM wParam, LPARAM lParam){
	PAINTSTRUCT ps;
	HDC hdc;

	hdc = BeginPaint(&ps);
//	TextOut(hdc, 0, 0, "   ȭ", 21);
	EndPaint(&ps);
}

void cGameCreateDlg::OnCreate(LPARAM lParam){
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "edit", NULL, 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE, 
		32, 32, 334, 32, hWnd, (HMENU)IDC_NAME_EDIT, hInstance, NULL);

	::SendMessage(GetItem(IDC_NAME_EDIT)->hWnd, EM_SETLIMITTEXT, 40, 0);

	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON, 
		32, 160, 64, 32, hWnd, (HMENU)IDOK, hInstance, NULL);

	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 
		304, 160, 64, 32, hWnd, (HMENU)IDCANCEL, hInstance, NULL);
}

void cGameCreateDlg::OnDestroy(){
}


BOOL cGameCreateDlg::OnCommand(WPARAM wParam, LPARAM lParam){
	char buff[41];
	switch(LOWORD(wParam)){
	case IDOK:
		::GetWindowText(GetItem(IDC_NAME_EDIT)->hWnd, buff, 41);
		if(!pGameInfo->SetName(buff)){
			MessageBox("̸  ʽϴ.\nٽ Է ֽʽÿ.", "", MB_OK);
			return false;
		}
		break;
	}
	return true;
}
