// cGameInfoList.cpp: implementation of the cGameInfoList class.
//
//////////////////////////////////////////////////////////////////////

#include "cGameInfoList.h"


static bool DeleteTree(char *PathName, char *FileName){
	HANDLE hFindFile;
	WIN32_FIND_DATA FindData;
	int len;
	char Path[MAX_PATH];

	if(!FileName) return false;
	strcpy(Path, PathName);
	strcat(Path, "\\");
	len = strlen(Path);
	strcat(Path, FileName);

	hFindFile = FindFirstFile(Path, &FindData);
	if(hFindFile == INVALID_HANDLE_VALUE) return false;
	do{
		strcpy(Path + len, FindData.cFileName);
		if(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
			if(strcmp(FindData.cFileName, ".") == 0) continue;
			if(strcmp(FindData.cFileName, "..") == 0) continue;
			if(DeleteTree(Path, "*.*")){
				RemoveDirectory(Path);
			}
		}else{
			DeleteFile(Path);
		}
	} while(FindNextFile(hFindFile, &FindData));
	FindClose(hFindFile);
	return true;

}

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cGameInfoList::cGameInfoList(){
	FolderName = "";
	hFindFile = INVALID_HANDLE_VALUE;

}

/*
cGameInfoList::cGameInfoList(char *_FolderName){
	FolderName = _FolderName;
	hFindFile = INVALID_HANDLE_VALUE;
}
*/

cGameInfoList::~cGameInfoList(){
	if(hFindFile != INVALID_HANDLE_VALUE) FindClose(hFindFile);
}

bool cGameInfoList::Open(char *_FolderName){
	WIN32_FIND_DATA FindData;
	HANDLE hFindFile;

	FolderName = _FolderName;

	//     غѴ.
	hFindFile = FindFirstFile(FolderName, &FindData);
	if(hFindFile == INVALID_HANDLE_VALUE){
		if(!CreateDirectory(FolderName, NULL)) return false;		
	}else if(!(FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)){
		return false;
	}
	return true;
}

void cGameInfoList::Close(){

}



void cGameInfoList::EndFind(){
	if(hFindFile != INVALID_HANDLE_VALUE){
		FindClose(hFindFile);
		hFindFile = INVALID_HANDLE_VALUE;
	}
}

bool cGameInfoList::FindFirst(){
	char FileName[MAX_PATH];
	WIN32_FIND_DATA FindFileData;

	if(hFindFile != INVALID_HANDLE_VALUE) FindClose(hFindFile);
	Exist = false;

	strcpy(FileName, FolderName);
	strcat(FileName, "\\*.*");

	hFindFile = FindFirstFile(FileName, &FindFileData);
	if(hFindFile == INVALID_HANDLE_VALUE) return false;
	if(!(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
		return false;
	if(strcmp(FindFileData.cFileName, ".") == 0
		|| strcmp(FindFileData.cFileName, "..") == 0)
		return FindNext();

	Exist = true;
	GameInfo.SetName(FindFileData.cFileName);

	return true;
}

bool cGameInfoList::FindNext(){
	WIN32_FIND_DATA FindFileData;

	Exist = false;
	if(hFindFile == INVALID_HANDLE_VALUE) return false;
	do{
		if(!FindNextFile(hFindFile, &FindFileData)) return false ;
		if(!(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			return false;
	}while(strcmp(FindFileData.cFileName, ".") == 0
		|| strcmp(FindFileData.cFileName, "..") == 0);
	Exist = true;
	GameInfo.SetName(FindFileData.cFileName);

	return true;
}

bool cGameInfoList::IsExist(){
	return Exist; //if(hFindFile == INVALID_HANDLE_VALUE) return false;
//	return true;
}

bool cGameInfoList::GetItem(cGameInfo &gi){
	if(!Exist) return false;
	gi = GameInfo;
	return true;
}

bool cGameInfoList::Add(cGameInfo &gi){
	char FileName[MAX_PATH];

	strcpy(FileName, FolderName);
	strcat(FileName, "\\");
	strcat(FileName, gi.GetName());

	if(!CreateDirectory(FileName, NULL)) return false;
	return true;
}

bool cGameInfoList::Erase(cGameInfo &gi){
//	char FileName(_MAX_PATH);
//	SHFileOperation
	return DeleteTree(FolderName, gi.GetName());
}


