// cGameSelectWindow.cpp: implementation of the cGameSelectWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "cGameSelectWindow.h"
#include "TOOLMemory.h"
#include "cASAppWindow.h"
#include "cGameCreateDlg.h"
#include "cLoginDlg.h"

#include "resource.h"

BOOL cGameSelectWindow::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cGameSelectWindow::cGameSelectWindow(){
}

cGameSelectWindow::~cGameSelectWindow(){
	Destroy();
}

//////////////////////////////////////////////////////////////////////
// Window Class Register / Create Window Extended
//////////////////////////////////////////////////////////////////////
BOOL cGameSelectWindow::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, LoadCursor(hInstance, MAKEINTRESOURCE(IDC_AS)),
		HBRUSH(COLOR_BTNFACE + 1));
	return ClassRegistered;
}

BOOL cGameSelectWindow::Create(cWindow *_pParent, cASEssence *_pEssence){
	RECT rc;

	pEssence = _pEssence;

	GetParent()->GetClientRect(&rc);

	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		NULL, // Caption
		WS_CHILD | WS_VISIBLE, // Window Style
		rc.left, rc.top, // x, y
		rc.right, rc.bottom, // Width, Height
		_pParent, // Parent Window
		NULL); // Menu
}

//////////////////////////////////////////////////////////////////////
// Window Procedure
//////////////////////////////////////////////////////////////////////

LRESULT cGameSelectWindow::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		OnCreate(lParam);
		break;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_COMMAND:
		OnCommand(wParam, lParam);
		return 0;
	}
	return cWindow::Proc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////
void cGameSelectWindow::OnCreate(LPARAM lParam){
	UserInfo.SetName("GameSel");

	// ϵ Ʈ   Ѵ.
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "listbox", " ", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | WS_VSCROLL | LBS_SORT | LBS_NOTIFY,
		32, 64, 560, 160, hWnd, (HMENU)IDC_GAME_LIST, hInstance, NULL); 
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", " ", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		32, 240, 100, 32, hWnd, (HMENU)IDC_NEW_BTN, hInstance, NULL);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "", 
		WS_TABSTOP | WS_DISABLED | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 
		140, 240, 100, 32, hWnd, (HMENU)IDC_DELETE_BTN, hInstance, NULL);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "<< ", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 
		32, 420, 100, 32, hWnd, (HMENU)IDC_CANCEL_BTN, hInstance, NULL);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", " >>", 
		WS_TABSTOP | WS_DISABLED | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON | BS_DEFPUSHBUTTON, 
		500, 420, 100, 32, hWnd, (HMENU)IDC_NEXT_BTN, hInstance, NULL);

	// ü Ƚó   ͸ ´.
	cGameInfoList *pGameInfoList = *pEssence;
	if(!pGameInfoList){
		MessageBox("    ϴ.", "", MB_OK);
		PostMessage(WM_CLOSE, 0, 0);
		return;
	}
	//  Ʈ Ʈѿ ׸ Ѵ.
	cGameInfo gi;
	for(pGameInfoList->FindFirst(); pGameInfoList->IsExist(); pGameInfoList->FindNext()){
		pGameInfoList->GetItem(gi);
		::SendMessage(GetItem(IDC_GAME_LIST)->hWnd, LB_ADDSTRING, 0, (LPARAM)(gi.GetName()));
	}
	if(SendMessage(GetItem(IDC_GAME_LIST)->hWnd, LB_SETCURSEL, 0, 0) != LB_ERR){
		EnableWindow(GetItem(IDC_DELETE_BTN)->hWnd, TRUE);
		EnableWindow(GetItem(IDC_NEXT_BTN)->hWnd, TRUE);
	}
}

void cGameSelectWindow::OnDestroy(){
}


void cGameSelectWindow::OnCommand(WPARAM wParam, LPARAM lParam){
	switch(LOWORD(wParam)){ // Control ID
	case IDC_GAME_LIST: 
		switch(HIWORD(wParam)){ // Notification Code
		case LBN_SELCANCEL:
			EnableWindow(GetItem(IDC_DELETE_BTN)->hWnd, FALSE);
			break;
		case LBN_SELCHANGE:
			EnableWindow(GetItem(IDC_DELETE_BTN)->hWnd, TRUE);
			EnableWindow(GetItem(IDC_NEXT_BTN)->hWnd, TRUE);
			break;
		case LBN_DBLCLK:
			OnNextBtnClicked();
			break;
		}
		break;
	case IDC_NEW_BTN:
		OnNewBtnClicked();
		break;
	case IDC_DELETE_BTN:
		OnDeleteBtnClicked();
		break;
	case IDC_CANCEL_BTN:
		PostMessage(GetParent(), WM_COMMAND, (WPARAM)GS_CANCEL, (LPARAM)hWnd);
		break;
	case IDC_NEXT_BTN:
		OnNextBtnClicked();
		break;

	}
}

void cGameSelectWindow::OnNewBtnClicked(){
// ο  ߰  ֵ Ѵ.
	cGameInfo GameInfo;
	cGameCreateDlg dlg;
	cGameInfoList *pGameInfoList = *pEssence;

	if(dlg.DoModal(this, &GameInfo) == IDOK){
		if(!pGameInfoList->Add(GameInfo)){
			MessageBox(hWnd, " ̸  ʰų\n  ̸  ճ.\nٸ ̸ Էϼ!", "", MB_OK);
			return;
		}
		SendMessage(GetItem(IDC_GAME_LIST), LB_ADDSTRING, 0, (LPARAM)GameInfo.GetName());
		EnableWindow(GetItem(IDC_NEXT_BTN), TRUE);
	}
}

void cGameSelectWindow::OnDeleteBtnClicked(){
// õ  .
	cGameInfo gi;
	int Index;
	cGameInfoList *pGameInfoList = *pEssence;

	Index = SendMessage(GetItem(IDC_GAME_LIST), LB_GETCURSEL, 0, 0);
	if(Index == LB_ERR) return;

	SendMessage(GetItem(IDC_GAME_LIST), LB_GETTEXT, Index, LPARAM(gi.GetName()));
	SendMessage(GetItem(IDC_GAME_LIST), LB_DELETESTRING, Index, 0);
	pGameInfoList->Erase(gi);
	if(SendMessage(GetItem(IDC_GAME_LIST), LB_SETCURSEL, 0, 0) != LB_ERR){
		EnableWindow(GetItem(IDC_DELETE_BTN), TRUE);
		EnableWindow(GetItem(IDC_NEXT_BTN), TRUE);
	}else{
		EnableWindow(GetItem(IDC_DELETE_BTN), FALSE);
		EnableWindow(GetItem(IDC_NEXT_BTN), FALSE);
	}
}

void cGameSelectWindow::OnNextBtnClicked(){
	//  ID  α Ѵ.
	cLoginDlg LoginDlg;
//	cNewPlayerDlg NewDlg;

	cGameInfo giSelected, gi;
	int Index;

	Index = SendMessage(GetItem(IDC_GAME_LIST), LB_GETCURSEL, 0, 0);
	if(Index == LB_ERR) return;

	SendMessage(GetItem(IDC_GAME_LIST), LB_GETTEXT, Index, LPARAM(giSelected.GetName()));

	// õ  ã´.
	cGameInfoList *pGameInfoList = *pEssence;
	for(pGameInfoList->FindFirst(); pGameInfoList->IsExist(); pGameInfoList->FindNext()){
		pGameInfoList->GetItem(gi);
		if(gi == giSelected){
			if(LoginDlg.DoModal(this, &UserInfo) == IDOK){
				PostMessage(GetParent(), WM_COMMAND, GS_OK, (LPARAM)hWnd);
			}
			break;
		}
	}
}

void cGameSelectWindow::GetGameData(cGameInfo *pGameInfo, cUserInfo *pUserInfo){
	*pGameInfo = GameInfo;
	*pUserInfo = UserInfo;
}
