/*
	// BRGLexer
	  ϰ ִٰ
	 Է ָ мѴ.

	* Regular Grammer
	1. Individual terminal symbols are regular expressions.
	2. If a and b are regular expressions, 
		then so are: a | b, ab, (a), and a*.
	3. Nothing else is a regular expression.




*/

#ifndef cLexer_H
#define cLexer_H

#include <windows.h>
#include "cQueue.h"

enum eGrammerRelation{
	GR_ASCII, GR_AND, GR_OR, GR_REPEAT
};

struct sBRG{
	eGrammerRelation Relation;
	int First; //  ε Ÿų, ƽŰ ڵ带 Ÿ.
	int Second;
	int RealIdx;
};

struct sRegularGrammar{
	char *Symbol;
	char *Grammar;
};

class cRGToBG{
protected:
	cQueue<sBRG> brgq;
	sRegularGrammar *prg;
	BOOL *ParseIdx;
	int RGCount;
	int BGCount;

	int ExtractGrammar(char *pg, int *idx);
	int ExtractOr(char *pg, int *idx);
	int ExtractAnd(char *pg, int *idx);
	int ExtractStar(char *pg, int *idx);
	int ExtractSymbol(char *pg, int *idx);
	int ExtractRange(char *pg, int *idx);
	int ExtractNumber(char *pg, int *Value);

public:
	cRGToBG();
	~cRGToBG();
	int SetGrammar(sRegularGrammar *_prg, int RGCount);
	void GetBinaryGrammar(sBRG *pbrg);
};



class cLexer{
protected:
	sBRG *Grammars;
	int RegularGrammarCount;
	int GrammarCount;

	int IsMatch(int idx, char *pInput, char *pLexeme);
//	int GetID(char *&pInput, char *pLexeme, int Limit);
//	int ExtractGrammar(sRegularGrammar *pRG[i], std::queue<sBRG> *BRGQ);

	int RegularGrammar();
	int Or();


public:
	cLexer();
	virtual ~cLexer();

	BOOL SetGrammar(sRegularGrammar *_RG, int _RGCount);
	int GetLexeme(char *&pInput, char *Lexeme, int MaxLen);

};

#endif 
