// cLoginDlg.cpp: implementation of the cLoginDlg class.
//
//////////////////////////////////////////////////////////////////////

#include "cLoginDlg.h"
#include "TOOLMemory.h"

BOOL cLoginDlg::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cLoginDlg::cLoginDlg(){
}

cLoginDlg::~cLoginDlg(){
}

//////////////////////////////////////////////////////////////////////
// Window Class Register / Create Window Extended
//////////////////////////////////////////////////////////////////////
BOOL cLoginDlg::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW)),
		HBRUSH(COLOR_BTNFACE + 1));
	return ClassRegistered;
}

BOOL cLoginDlg::Create(cWindow *_pParent){
	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		"α մϴ", // Caption
		WS_POPUP | WS_CAPTION | WS_VISIBLE,
		GetSystemMetrics(SM_CXSCREEN) / 2 - 200, // x
		GetSystemMetrics(SM_CYSCREEN) / 2 - 120, // y
		400, 240, // Width, Height
		_pParent, // Parent Window
		NULL); // Menu
}

int cLoginDlg::DoModal(cWindow *_pParent, cUserInfo *_pUserInfo){
	pUserInfo = _pUserInfo;

	return cDialog::DoModal(_pParent);
}

//////////////////////////////////////////////////////////////////////
// Window Procedure
//////////////////////////////////////////////////////////////////////

LRESULT cLoginDlg::WindowProc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		OnCreate(lParam);
		return 0;
	case WM_DESTROY:
		OnDestroy();
		return 0;
	case WM_COMMAND:
		if(OnCommand(wParam, lParam)) break;
		return 0;
	}
	return cDialog::Proc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////
void cLoginDlg::OnCreate(LPARAM lParam){
	CreateWindowEx(WS_EX_LEFT, "static", "̸", 
		WS_CHILD | WS_VISIBLE, 
		8, 8, 48, 32, hWnd, NULL, hInstance, NULL);
	CreateWindowEx(WS_EX_LEFT, "static", "ȣ", 
		WS_CHILD | WS_VISIBLE, 
		8, 60, 48, 32, hWnd, NULL, hInstance, NULL);

	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "edit", "Toltin", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE, 
		64, 8, 104, 32, hWnd, (HMENU)IDC_NAME_EDIT, hInstance, NULL);
	::SendMessage(GetItem(IDC_NAME_EDIT), EM_SETLIMITTEXT, 12, 0);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "edit", "rlawjdtj", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | ES_PASSWORD, 
		64, 60, 104, 32, hWnd, (HMENU)IDC_PASSWORD_EDIT, hInstance, NULL);
	SendMessage(GetItem(IDC_PASSWORD_EDIT), EM_SETLIMITTEXT, 12, 0);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "Ȯ", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_DEFPUSHBUTTON, 
		208, 8, 64, 32, hWnd, (HMENU)IDOK, hInstance, NULL);
	CreateWindowEx(WS_EX_LEFT | WS_EX_CLIENTEDGE, "button", "", 
		WS_TABSTOP | WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 
		208, 60, 64, 32, hWnd, (HMENU)IDCANCEL, hInstance, NULL);

}

void cLoginDlg::OnDestroy(){
}


BOOL cLoginDlg::OnCommand(WPARAM wParam, LPARAM lParam){
	char buff[41];
	switch(LOWORD(wParam)){
	case IDOK:
		GetWindowText(GetItem(IDC_NAME_EDIT), buff, 41);
		if(!pUserInfo->SetName(buff)){
			MessageBox(hWnd, "̸  ʽϴ.\nٽ Է ֽʽÿ.", "", MB_OK);
			return false;
		}
		GetWindowText(GetItem(IDC_PASSWORD_EDIT), buff, 41);
		if(!pUserInfo->SetPassword(buff)){
			MessageBox(hWnd, "ȣ  ʽϴ.\nٽ Է ֽʽÿ.", "", MB_OK);
			return false;
		}
		break;
	}
	return true;
}
