// cMedium.cpp: implementation of the cMedium class.
//
//////////////////////////////////////////////////////////////////////

#include "cMedium.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
cMedium::cMedium(){
	pFile = NULL;
}

cMedium::cMedium(const char *pFileName){
	pFile = NULL;
	SetFileName(pFileName);
}

cMedium::~cMedium(){
	if(pFile) Close();
}

void cMedium::SetFileName(const char *pFileName){
	strncpy(FileName, pFileName, _MAX_FNAME);

}

bool cMedium::Open(DWORD Mode){
	char *pom;
	switch(Mode){
	case OM_READ:
		pom = "rb"; break;
	case OM_WRITE:
		pom = "wb"; break;
	case OM_READ | OM_WRITE:
		pom = "r+"; break;
	case OM_READ | OM_WRITE | OM_CREATE:
		pom = "w+"; break;
	default:
		return false;
	}

	pFile = fopen(FileName, pom);
	if(!pFile) return false;
	return true;
}

void cMedium::Close(){
	if(pFile) fclose(pFile);
	pFile = NULL;
}

bool cMedium::Seek(int Offset, eSeekMode SeekMode){
	int sm;

	switch(SeekMode){
	case SM_BEGIN: sm = SEEK_SET; break;
	case SM_CUR: sm = SEEK_CUR; break;
	case SM_END: sm = SEEK_END; break;
	default: 
		return false;
	}
	if(fseek(pFile, Offset, sm))
		return false;
	return true;
}

int cMedium::Read(void *pBuff, DWORD Size, DWORD Count){
	return fread(pBuff, Size, Count, pFile);
}

int cMedium::Write(const void *pBuff, DWORD Size, DWORD Count){
	return fwrite(pBuff, Size, Count, pFile);
}
