// cDDPicture.h: interface for the cDDPicture class.
//
//////////////////////////////////////////////////////////////////////
/*
	 ׸ .
	׸ ̷Ʈ ο ǥ Ϻκ   ִ.
*/
#ifndef cPicture_H 
#define cPicture_H

#include <ddraw.h>
#include "cMedium.h"
#include "cRecorder.h"

class cDisplay;

class cPicture : public cRecorder{
protected:
	enum eSurfaceType{
		ST_NONE = 0, // ǥ غǾ  ʴ.
		ST_MEMORY_SURFACE, // ũ ǥ
		ST_PICTURE_SURFACE, // ׸ ε  ǥ
		ST_PIECE_SURFACE // ǥ 
	};

//  ÷
private:
	static LPDIRECTDRAW pDD;
protected:
	static cDisplay *pDisplay;

public:
	static void SetDisplay(cDisplay *_pDisplay);
	static cDisplay *GetDisplay(){ return pDisplay; }

// ǥ 
protected:
	LPDIRECTDRAWSURFACE pDDS; // ׸  ϴ ǥ
	eSurfaceType SurfaceType; // ׸ 

	RECT Rect; // ǥ 簢  ׸ ȴ.
	cMedium *pMedium; // ׸ ü


// ǥ 
	BOOL Restore();

public:
	cPicture();
	virtual ~cPicture();

	// ׸  ̽
	BOOL Create(int BackBufferCount = 0);
	BOOL Create(cPicture &Src);
	BOOL Create(DWORD Width, DWORD Height);
	BOOL CreateReference(cPicture &Src, int Left, int Top, int Right, int Bottom);
	void Destroy();

	// ׸ Ϸ  ǥ  .
	BOOL Create(cMedium *_pMedium);

	// ׸ Ӽ 
	BOOL GetSize(LPSIZE psz);
	int GetWidth();
	int GetHeight();
	LPDIRECTDRAWSURFACE GetBackPic(int Index = 0);
	cMedium *GetMedium(){ return pMedium; }
	void DeleteMedium(){ if(pMedium) delete pMedium; pMedium = NULL; }
	void SetArea(LPDIRECTDRAWSURFACE _pDDS, RECT *pRect);
	BOOL SetClipWindow(HWND hWnd);
	BOOL SetColorKey(DWORD dwFlags, DDCOLORKEY *pddck){ return pDDS->SetColorKey(dwFlags, pddck) == DD_OK; }

	// ׸
	BOOL Blt(LPRECT lpDestRect, cPicture *pSrc, LPRECT lpSrcRect, DWORD dwFlags, LPDDBLTFX lpDDBltFx);
	BOOL BltFast(DWORD x, DWORD y, cPicture *pSrc, LPRECT lpSrcRect, DWORD dwFlags);
	BOOL GetDC(HDC *phdc){ return pDDS->GetDC(phdc) == DD_OK; }
	BOOL ReleaseDC(HDC hdc){ return pDDS->ReleaseDC(hdc) == DD_OK; }

	// ׸ εѴ.
	void operator =(LPDIRECTDRAWSURFACE _pDDS);
	// ̷Ʈ ο ǥ 
	operator LPDIRECTDRAWSURFACE(){ return pDDS; }
	LPDIRECTDRAWSURFACE GetDDS(){ return pDDS; }
};

#endif 
