// cPictureBook.cpp: implementation of the cPictureBook class.
//
//////////////////////////////////////////////////////////////////////

#include "cPictureBook.h"
#include "cArray.cpp"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cPictureBook::cPictureBook(){

}

cPictureBook::~cPictureBook(){

}

cPicture *cPictureBook::GetPicture(int Idx){
	return Elements + Idx;
}

BOOL cPictureBook::LoadPicture(int idx, char *FileName){
	cMedium *pMedium;

	pMedium = new cMedium(FileName);
	
	return Elements[idx].Create(pMedium);
}

BOOL cPictureBook::CropPicture(int DestIdx, int SrcIdx, int Left, int Top, int Right, int Bottom){
	cPicture *SrcPic;
	cPicture *DestPic;

	SrcPic = GetPicture(SrcIdx);
	DestPic = GetPicture(DestIdx);
	return DestPic->CreateReference(*SrcPic, Left, Top, Right, Bottom);
}

BOOL cPictureBook::AutoCropPicture(char *FileName, 
		int PictureCount, int Width, int Height){
	int i, x, y;
	int PictureWidth;

	if(!Create(PictureCount + 1))
		return FALSE;

	if(!LoadPicture(GetCount() - 1, FileName))
		return FALSE;

	PictureWidth = GetPicture(GetCount() - 1)->GetWidth();

	x = 0; y = 0;

	for(i = 0; i < PictureCount; i ++){
		CropPicture(i, ElementCount - 1, x, y, x + Width, y + Height);
		x += Width;
		if(x + Width > PictureWidth){
			x = 0;
			y += Height;
		}
	}
	return TRUE;
}
