#include "cDisplay.h"
#include "cPictureButton.h"
//#include "TOOLMemory.h"


BOOL cPictureButton::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cPictureButton::cPictureButton(){

}

cPictureButton::~cPictureButton(){
	Destroy();
}

BOOL cPictureButton::RegisterClass(){

	ClassRegistered = cWindow::RegisterClass(CS_HREDRAW | CS_VREDRAW);
	return ClassRegistered;
}

BOOL cPictureButton::Create(DWORD dwStyle, char *caption, int x, int y, int Width, int Height, cWindow *pParent, DWORD Id,
							cPicture *_pDestPic, cPicture *_pPicture){
	pDestPic = _pDestPic;
	pPicture = _pPicture;
	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		caption, // Caption
		dwStyle, // Window Style
		x, y,// x, y
		Width, Height,
		pParent, // Parent Window
		(HMENU)Id); // Menu
}

//////////////////////////////////////////////////////////////////////
// Window Prodedure
//////////////////////////////////////////////////////////////////////

LRESULT cPictureButton::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		Downed = FALSE;
		return 0;
	case WM_SETFOCUS:
	case WM_KILLFOCUS:
		InvalidateRect(NULL, FALSE);
		return 0;
	case WM_LBUTTONDOWN:
		SetFocus();
		SetCapture();
		Downed = TRUE;
		InvalidateRect(NULL, FALSE);
		return 0;
	case WM_MOUSEMOVE:
	{
		RECT rc;
		POINT pt;
		if(GetCapture() == this){
			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			GetClientRect(&rc);
			if(PtInRect(&rc, pt)){
				if(wParam & MK_LBUTTON) Downed = TRUE;
				else Downed = FALSE;
				if(GetCapture() != this){
					SetCapture();
				}
			}else{
				if(!(wParam & MK_LBUTTON))
					ReleaseCapture();
				Downed = FALSE;
			}
			InvalidateRect(NULL, FALSE);
		}else{ // 콺 
			SetCapture();
			Downed = FALSE;
			InvalidateRect(NULL, FALSE);
		}
		return 0;
	}
	case WM_LBUTTONUP:
	{
		RECT rc;
		POINT pt;

		if(GetCapture() == this){
			pt.x = LOWORD(lParam);
			pt.y = HIWORD(lParam);
			GetClientRect(&rc);
			if(PtInRect(&rc, pt)){
				SetFocus();
				GetParent()->PostMessage(WM_COMMAND, (WPARAM)GetMenu(), LPARAM(hWnd));
			}

			ReleaseCapture();
			InvalidateRect(NULL, FALSE);
		}
		return 0;
	}

	case WM_PAINT:
		OnPaint(wParam);
		return 0;
	}
	return DefProc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////


void cPictureButton::OnPaint(WPARAM wParam){
	PAINTSTRUCT ps;
	RECT rcWindow, rcClient, rcSrc;
	SIZE szPic, szText;
	int x, y, cx, cy, LenText, idx;
	HDC hdc;
	char pText[256];

	// 츦 ׸ Ѵ.
	BeginPaint(&ps);
	EndPaint(&ps);

	// ׷ ׸ ľѴ.
	if(IsEnabled()){
		if(GetCapture() == this){
			if(Downed) idx = 2;
			else idx = 1;
		}else idx = 0;
	}else idx = 4;

	GetClientRect(&rcClient);
	pPicture->GetSize(&szPic);
	cx = szPic.cx / rcClient.right;
	cy = szPic.cy / rcClient.bottom;

	rcSrc.left = (idx % cx) * rcClient.right;
	rcSrc.top = (idx / cx) * rcClient.bottom;
	rcSrc.right = rcSrc.left + rcClient.right;
	rcSrc.bottom = rcSrc.top + rcClient.bottom;

	// ׸ ׷.
	GetRect(&rcWindow);

	ShowCursor(FALSE);
	pDestPic->SetClipWindow(hWnd);
	pDestPic->Blt(&rcWindow, pPicture, &rcSrc, DDBLT_WAIT, NULL);

	GetText(pText, 256);
	LenText = strlen(pText);
	if(LenText > 0){
		if(pDestPic->GetDC(&hdc)){
			SetBkMode(hdc, TRANSPARENT);
			GetTextExtentPoint(hdc, pText, LenText, &szText);
			x = (rcWindow.left + rcWindow.right - szText.cx) / 2;
			y = (rcWindow.top + rcWindow.bottom - szText.cy) / 2;
			switch(idx){
			case 0:
				SetTextColor(hdc, RGB(96, 96, 96));
				TextOut(hdc, x + 1, y + 1, pText, LenText);
				TextOut(hdc, x, y, pText, LenText);
				break;
			case 1:
				SetTextColor(hdc, RGB(0, 0, 0));
				TextOut(hdc, x + 1, y + 1, pText, LenText);
				TextOut(hdc, x, y, pText, LenText);
				break;
			case 2:
				SetTextColor(hdc, RGB(0, 0, 0));
				TextOut(hdc, x + 1, y + 1, pText, LenText);
				break;
			case 3:
				SetTextColor(hdc, RGB(255, 255, 255));
				TextOut(hdc, x + 1, y + 1, pText, LenText);
				SetTextColor(hdc, RGB(96, 96, 96));
				TextOut(hdc, x, y, pText, LenText);
				break;
			}
			pDestPic->ReleaseDC(hdc);
		}
	}
	ShowCursor(TRUE);

}
