// cPictureWindow.cpp: implementation of the cPictureWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "cPictureWindow.h"

BOOL cPictureWindow::ClassRegistered = FALSE;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cPictureWindow::cPictureWindow(){

}

cPictureWindow::~cPictureWindow(){

}

BOOL cPictureWindow::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(CS_HREDRAW | CS_VREDRAW);
	return ClassRegistered;
}

BOOL cPictureWindow::Create(DWORD dwStyle, int x, int y, int Width, int Height, 
							cWindow *_pParent, int id, cPicture *_pDestPic, cPicture *_pBackPic){

	pDestPic = _pDestPic;
	pBackPic = _pBackPic;

	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		NULL, // Caption
		dwStyle, // Window Style
		x, y,// x, y
		Width, Height,
		_pParent, // Parent Window
		(HMENU)id); // Menu
}

LRESULT cPictureWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_PAINT:
		OnPaint(wParam);
		return 0;

	}
	return DefProc(uMsg, wParam, lParam);
}

void cPictureWindow::OnPaint(WPARAM wParam){
	PAINTSTRUCT ps;
	RECT rcWindow;

	BeginPaint(&ps);
	EndPaint(&ps);

	GetRect(&rcWindow);

	pDestPic->SetClipWindow(hWnd);
	pDestPic->Blt(&rcWindow, pBackPic, NULL, DDBLT_WAIT, NULL);
}
