// cPointerSet.cpp: implementation of the cPointerSet class.
//
//////////////////////////////////////////////////////////////////////

#include "cPointerSet.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template<class Type>
cPointerSet<Type>::cPointerSet(){
	Pointers = NULL;
}

template<class Type>
cPointerSet<Type>::~cPointerSet(){
	if(Pointers) delete [] Pointers;
}

template<class Type>
BOOL cPointerSet<Type>::Create(int Size){
	PointerCount = Size;
	Pointers = new Type *[PointerCount];
	return Pointers != NULL;
}

template<class Type>
void cPointerSet<Type>::Destroy(){
	if(Pointers) delete [] Pointers;
	Pointers = NULL;
}

template<class Type>
void cPointerSet<Type>::Swap(int i, int j){
	Type *p;
	p = Pointers[i];
	Pointers[i] = Pointers[j];
	Pointers[j] = p;
}


template<class Type>
void cPointerSet<Type>::QuickSort(){
	QuickSort(0, PointerCount - 1);
}


template<class Type>
void cPointerSet<Type>::QuickSort(int Left, int Right){
	int i, j = Left, Key;

	if(Left >= Right) return;

	Key = Pointers[Left]->GetKey();

	for(i = Left + 1; i <= Right; i ++){
		if(Pointers[i]->GetKey() < Key){
			j ++;
			Swap(i, j);
		}
	}
	Swap(Left, j);
	QuickSort(Left, j - 1);
	QuickSort(j + 1, Right);
}
