#include "cDisplay.h"
#include "cPopupMenu.h"
#include "TOOLMemory.h"


BOOL cPopupMenu::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cPopupMenu::cPopupMenu(){
	Buttons = NULL;

}

cPopupMenu::~cPopupMenu(){
	Destroy();
}

BOOL cPopupMenu::RegisterClass(){

	ClassRegistered = cWindow::RegisterClass(CS_HREDRAW | CS_VREDRAW);
	return ClassRegistered;
}

BOOL cPopupMenu::Create(DWORD dwStyle, int x, int y, int Width, int Height, 
		cWindow *_pParent, int id, cPicture *_pDestPic, cPicture *_pBackPic,
		sPopupMenuItem *_MenuItems, int _MaxItem){

	MenuItems = _MenuItems;
	MaxItem = _MaxItem;
	Buttons = NULL;
	pDestPic = _pDestPic;

	return cPictureWindow::Create(
		dwStyle, x, y, Width, Height,
		_pParent, id, pDestPic, _pBackPic);
}

//////////////////////////////////////////////////////////////////////
// Window Prodedure
//////////////////////////////////////////////////////////////////////

LRESULT cPopupMenu::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		return OnCreate(wParam);
	case WM_DESTROY:
		OnDestroy();
		return 0;
	case WM_COMMAND:
		PostQuitMessage(wParam);
//		GetParent()->SendMessage(WM_COMMAND, WPARAM(GetMenu()), LPARAM(
		return 0;
	}
	return cPictureWindow::Proc(uMsg, wParam, lParam);
}

int cPopupMenu::OnCreate(WPARAM wParam){
	int i;
	Buttons = new cPictureButton [MaxItem];
	for(i = 0; i < MaxItem; i ++){
		if(!Buttons[i].Create(WS_CHILD | WS_VISIBLE, MenuItems[i].Caption, MenuItems[i].x, MenuItems[i].y,
			MenuItems[i].Width, MenuItems[i].Height,
			this, MenuItems[i].id, pDestPic, MenuItems[i].pPicture))
			return -1;
	}

	return 0;
}

void cPopupMenu::OnDestroy(){
	if(Buttons){
		delete [] Buttons;
		Buttons = NULL;
	}
}

