#include "cQueue.h"

template <class T> cQueue<T>::cQueue(){
	Head = Tail = NULL;
}

template <class T> cQueue<T>::~cQueue(){
	Clear();
}

template <class T> void cQueue<T>::Clear(){
	sQueueNode *Temp;

	while(Head){
		Temp = Head->Link;
		delete Head;
		Head = Temp;
	}
	Tail = NULL;
}

template <class T> bool cQueue<T>::IsEmpty(){
	return Head == NULL;
}

template <class T> void cQueue<T>::Add(T &NewData){
	sQueueNode *Temp;

	Temp = new sQueueNode;
	Temp->Data = NewData;
	Temp->Link = NULL;
	if(Tail){
		Tail->Link = Temp;
		Tail = Temp;
	}else{
		Tail = Temp;
		Head = Temp;
	}
}
template <class T> bool cQueue<T>::Get(T *Data){
	sQueueNode *Temp = Head;

	if(Head){
		*Data = Head->Data;
		if(Head == Tail){
			Head = NULL;
			Tail = NULL;
		}else{
			Head = Head->Link;
		}
		delete Temp;
		return true;
	}
	return false;
}

template <class T> bool cQueue<T>::GetHead(T *Data){
	if(Head){
		*Data = Head->Data;
		return true;
	}
	return false;
}

