#include "cStack.h"

template <class T> cStack<T>::cStack(){
	Top = NULL;
}

template <class T> cStack<T>::~cStack(){
	Clear();
}

template <class T> void cStack<T>::Clear(){
	sStackNode *Temp;

	while(Top){
		Temp = Top->Link;
		delete Top;
		Top = Temp;
	}
}

template <class T> bool cStack<T>::IsEmpty(){
	return Top == NULL;
}

template <class T> void cStack<T>::Push(T& NewData){
	sStackNode *Temp;

	Temp = new sStackNode;
	Temp->Data = NewData;
	Temp->Link = Top;
	Top = Temp;
}

template <class T> bool cStack<T>::Pop(T *Data){
	sStackNode *Temp = Top;

	if(Top){
		*Data = Top->Data;
		Top = Top->Link;
		delete Temp;
		return true;
	}
	return false;
}

template <class T> bool cStack<T>::GetTop(T *Data){
	if(Top){
		*Data = Top->Data;
		return true;
	}
	return false;
}
