/*
	cString

	A cString object consists of a variable-length of characters.
*/
#ifndef H_cString
#define H_cString

#include <string.h>
#include "TOOLType.h"
class cString{
protected:
	char *String;
	long Length;
	bool Allocate;

public:
	// Construction
	cString();
	cString(long nLength);
	cString(char *nString);
	cString(cString &A);
	~cString();

	void Create(long nSize);
	void Create(char *String);
	void Create(cString &A);

	void Destroy();

	// Buffer Access
	char *Get();

	// The String as an Array
	long GetLength();
	char Get(long i);
	void Set(long i, int c);

	// Block Operation
	void Copy(char *nString);
	void Copy(cString &A);
	void CopyAt(char *nString, int p, int n);
	void CopyAt(cString &A, int p, int n);

	// Expression
	void operator=(char *String);
	void operator=(cString &A);
	cString operator+(char *A);
	cString operator+(cString &A);
	friend cString operator+(char *s, cString &A);
	void operator+=(char *a);
	void operator+=(cString &A);

	// Extraction
	cString Middle(long p, long n);
	cString Left(long n);
	cString Right(long n);

	// Comparison
	int Compare(char *nString, bool Case = true);
	int Compare(cString &A, bool Case = true);
	bool operator==(char *nString);
	bool operator==(cString &A);

	// Conversion
	void ToLower();
	void ToUpper();

	// Searching
	long Find(int c, long p = 0);
	long Find(char *String, long p = 0);
	long Find(cString &String, long p = 0);
};

cString operator+(char *s, cString &A);

#endif
