// cStringListView.cpp: implementation of the cStringListView class.
//
//////////////////////////////////////////////////////////////////////

#include "cStringListView.h"

BOOL cStringListView::ClassRegistered = FALSE;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cStringListView::cStringListView(){

}

cStringListView::~cStringListView(){
	Destroy();
}

BOOL cStringListView::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		NULL, NULL,
		HBRUSH(GetStockObject(BLACK_BRUSH)));
	return ClassRegistered;
}

//////////////////////////////////////////////////////////////////////
// Window Prodedure
//////////////////////////////////////////////////////////////////////

LRESULT cStringListView::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		OnCreate(lParam);
		break;
	case WM_CLOSE:
		if(IsIconic())
			OpenIcon();
		else 
			Close();
		return 0;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_PAINT:
		OnPaint(wParam);
		return 0;
	}
	return DefProc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////
void cStringListView::OnCreate(LPARAM lParam){
	RECT rc;

	GetClientRect(&rc);
	StringArray.Create(rc.right / 8, rc.bottom / 16);
}

void cStringListView::OnDestroy(){
	StringArray.Destroy();
}

//////////////////////////////////////////////////////////////////////
// WM_PAINT
//////////////////////////////////////////////////////////////////////
void cStringListView::OnPaint(WPARAM wParam){
	RECT rcClient;
	PAINTSTRUCT ps;
	HDC hdc;
	char *String;
	int i;

	hdc = BeginPaint(&ps);
	if(!hdc) return;

	GetClientRect(&rcClient);

	SetBkMode(hdc, TRANSPARENT);
	for(i = 0; i < rcClient.bottom / 16; i ++){
		String = StringArray.GetString(i);
		SetTextColor(hdc, RGB(128, 128, 128));
		TextOut(hdc, 1, i * 16 + 1, String, strlen(String));
		SetTextColor(hdc, RGB(255, 255, 255));
		TextOut(hdc, 0, i * 16, String, strlen(String));
	}

	EndPaint(&ps);

}

///////////////////////////////////////////////////////
void cStringListView::Printf(char *Format, ...){
	va_list vaList;

	va_start(vaList, Format);

	StringArray.Printfv(Format, vaList);

	Invalidate(TRUE);
	UpdateWindow(hWnd);		

}

void cStringListView::Printfv(char *Format, va_list vaList){
	StringArray.Printfv(Format, vaList);

	Invalidate(TRUE);
	UpdateWindow(hWnd);		

}
