#include "stdinc.h"
#include "cTear.h"
#include "cTearsBoard.h"

cPictureBook *cTear::pPictureBook;

cTear::cTear(){
	State = TS_NONE;
	Kind = 0;
	Count = 0;
	Count2 = 0;
}

cTear::~cTear(){

}

int cTear::Act(){
	int RollDelay;

	switch(State){
	case TS_NONE:
		break;
	case TS_DOWNING:
		return Down();
	case TS_BREAKING:
		cEnergeticObject::Act();
		Energy.y += 64;
		if(TPToPP(y) >= 480) return TAR_REMOVE;
		break;
	case TS_SET:
		RollDelay = pBoard->GetRollDelay();
		if(RollDelay > 0){
			Count2 ++;
			Count2 %= RollDelay;
			if(Count2 == 0){
				if(Right) Count ++;
				else Count += 7;
			}
		}
		Count %= 8;
		break;
	}
	return TAR_NORMAL;
}

int cTear::Down(){
	int xBoard, yBoard;
	BOOL LeftOpen, RightOpen;
	int yOld;

	yOld = TPToBP(y);
	cEnergeticObject::Act();
	if(yOld < TPToBP(y)){
		y = BPToTP(yOld + 1);
	}
	// 簡  ¶
	if(Energy.x != 0){
		if(Energy.x < 0) Count += 7;
		else Count ++;
		Count %= 8;

		if(TPToBP(y) > yRoll){
			y = BPToTP(yRoll + 1);
			x = BPToTP(TPToBP(x + 320)); 
			Energy.x = 0;
		}else{
			return TAR_NORMAL;
		}
	}
	yBoard = TPToBP(y);
	xBoard = TPToBP(x);

	if(yBoard + 1 >= pBoard->GetHeight()){
		return TAR_BOTTOM;
	}
	if(pBoard->Get(yBoard + 1, xBoard) == NULL){
		return TAR_NORMAL;
	}

	LeftOpen = RightOpen = TRUE;
	if(xBoard - 1 < 0)
		LeftOpen = FALSE;
	else if(pBoard->Get(yBoard + 1, xBoard - 1) != NULL)
		LeftOpen = FALSE;

	if(xBoard + 1 >= pBoard->GetWidth())
		RightOpen = FALSE;
	else if(pBoard->Get(yBoard + 1, xBoard + 1) != NULL)
		RightOpen = FALSE;

	if(LeftOpen == FALSE && RightOpen == FALSE){
		return TAR_BOTTOM;
	}

	if(LeftOpen == TRUE && RightOpen == TRUE){
		if(rand() % 2) LeftOpen = FALSE;
		else RightOpen = FALSE;
	}

	if(LeftOpen){
		Energy.x = PPToTP(-8);
	}else{
		Energy.x = PPToTP(8);
	}
	Energy.y = PPToTP(8);
	y = BPToTP(yBoard);
	yRoll = yBoard;
	Count = 0;
	sndPlaySound("roll.wav", SND_ASYNC); 
	return TAR_NORMAL;
}

void cTear::SetState(eTearState _State){ 
	State = _State; 
	if(State == TS_BREAKING){
		Count = 0;
		Energy.x = (rand() % (16 * 20)) - (20 * 8);
		Energy.y = -(rand() % (40 * 16));
	}
	if(State == TS_SET){
		Count2 = 0;
		Count = 0;
		if(rand() % 2) Right = TRUE;
		else Right = FALSE;
	}
	if(State == TS_SELECTED){
		Count2 = 0;
		Count = 0;
	}
}

void cTear::Show(cPicture *pDestPic, int xRelative, int yRelative){
	RECT rcDest;
	int Idx;

	if(State == TS_BREAKING || State == TS_SELECTED){
		Idx = Kind * 11 + 8 + Count;
		Count ++;
		Count %= 3;
	}else{
		Idx = Kind * 11 + Count;
	}

	rcDest.left = xRelative + TPToPP(x);
	rcDest.top = yRelative + TPToPP(y);
	rcDest.right = rcDest.left + 40;
	rcDest.bottom = rcDest.top + 40;

	pDestPic->Blt(&rcDest, pPictureBook->GetPicture(Idx), NULL, DDBLT_WAIT | DDBLT_KEYSRC, NULL);
	// DDBLT_KEYSRC
}

void cTear::MoveLeft(){
	int xBoard, yBoard;
	xBoard = TPToBP(x);
	yBoard = TPToBP(y);
	if(xBoard > 0 && Energy.x == 0){
		if(pBoard->Get(yBoard, xBoard - 1) == NULL){
			if(yBoard < pBoard->GetHeight() - 1){
				if(pBoard->Get(yBoard + 1, xBoard - 1) != NULL){
					return;
				}
			}
			xBoard --;
			x = BPToTP(xBoard);
		}
	}
}

void cTear::MoveRight(){
	int xBoard, yBoard;
	xBoard = TPToBP(x);
	yBoard = TPToBP(y);
	if(xBoard < pBoard->GetWidth() - 1 && Energy.x == 0){
		if(pBoard->Get(yBoard, xBoard + 1) == NULL){
			if(yBoard < pBoard->GetHeight() - 1){
				if(pBoard->Get(yBoard + 1, xBoard + 1) != NULL){
					return;
				}
			}
			xBoard ++;
			x = BPToTP(xBoard);
		}
	}
}



void cTear::SetyEnergy(int n){
	if(Energy.x == 0) Energy.y = n;
}


