#ifndef cTear_H
#define cTear_H

#include "cPicture.h"
#include "cEnergeticObject.h"
#include "cVisualObject.h"
#include "cPictureBook.h"

enum eTearState{
	TS_NONE,
	TS_DOWNING,
	TS_SELECTED,
	TS_BREAKING,
	TS_SET
};

enum eTearActReturns{
	TAR_NORMAL,
	TAR_REMOVE,
	TAR_BOTTOM
};

class cTearsBoard;

#define TPToPP(a) ((a) >> 4)
#define PPToTP(a) ((a) << 4)
#define TPToBP(a) ((a) / 640)
#define BPToTP(a) ((a) * 640)

class cTear : 
	public cEnergeticObject,
	public cVisualObject{

protected:
	static cPictureBook *pPictureBook;

	cTearsBoard *pBoard;

	int Kind;
	int Count;
	int Count2;
	int yRoll;
	eTearState State;
	int Right;

	int Down();

public:
	cTear();
	virtual ~cTear();

	static void SetPictureBook(cPictureBook *_pPictureBook){ pPictureBook = _pPictureBook; }
	void SetBoard(cTearsBoard *_pBoard){ pBoard = _pBoard; }

	void SetKind(int _Kind){ Kind = _Kind; }
	void SetState(eTearState _State);
	eTearState GetState(){ return State; }
	int GetKind(){ return Kind; }

	virtual int Act();
	virtual void Show(cPicture *pDestPic, int xRelative, int yRelative);

	void MoveLeft();
	void MoveRight();
	void SetyEnergy(int n);

};

#endif