#include "stdinc.h"
#include "cTearsActionWindow.h"

const UINT RefreshTimerID = 1;

BOOL cTearsActionWindow::ClassRegistered = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
cTearsActionWindow::cTearsActionWindow(){
	pPlayer = NULL;
	pDisplay = NULL;
	pBackPicture = NULL;
}

cTearsActionWindow::~cTearsActionWindow(){
	Destroy();
}

BOOL cTearsActionWindow::RegisterClass(){
	ClassRegistered = cWindow::RegisterClass(CS_DBLCLKS, NULL, NULL, (HBRUSH)(COLOR_BTNFACE));
	return ClassRegistered;
}

BOOL cTearsActionWindow::Create(LPCTSTR lpWindowName, DWORD dwStyle, 
		int x, int y, int nWidth, int nHeight, 
		cWindow *pParentWindow, int id, cDisplay *_pDisplay){
	pDisplay = _pDisplay;
	return cWindow::Create(
		WS_EX_LEFT, // Extended Window Style
		lpWindowName, // Caption
		dwStyle, // Window Style
		x, y, nWidth, nHeight,
		pParentWindow, // Parent Window
		HMENU(id)); // Menu

}

void cTearsActionWindow::Destroy(){
	cWindow::Destroy();
}

void cTearsActionWindow::Set(cTearsPlayer *_pPlayer){
	pPlayer = _pPlayer;
}

//////////////////////////////////////////////////////////////////////
// Window Prodedure
//////////////////////////////////////////////////////////////////////

LRESULT cTearsActionWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CREATE:
		OnCreate(lParam);
		break;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_ERASEBKGND:
		return 0;
	case WM_PAINT:
		OnPaint(wParam);
		return 0;
	case WM_TIMER:
	//	Invalidate(FALSE);
		return 0;
	case WM_KEYDOWN:
		OnKeyDown(wParam, lParam);
		return 0;

	}
	return DefProc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Message Handlers
//////////////////////////////////////////////////////////////////////
void cTearsActionWindow::OnCreate(LPARAM lParam){
	// Ŭ۸ Ѵ.
	if(pDisplay){
		pDisplay->GetBackPic()->SetClipWindow(hWnd);
		pDisplay->GetFrontPic()->SetClipWindow(hWnd);
	}
	SetTimer(RefreshTimerID, 64);

}

void cTearsActionWindow::OnDestroy(){
	KillTimer(RefreshTimerID);
}

void cTearsActionWindow::OnPaint(WPARAM wParam){
	PAINTSTRUCT ps;
	RECT rcWindow;
	RECT rcClientUpdate;
	RECT rcWindowUpdate;

	// Ŭ  ´.
	BeginPaint(&ps);
	rcClientUpdate = ps.rcPaint;
	EndPaint(&ps);

	if(!pPlayer) return;

	if(!pBackPicture) return;

	// ׸ ׸.
	GetRect(&rcWindow);
	pDisplay->GetBackPic()->Blt(&rcWindow, pBackPicture, NULL, DDBLT_WAIT, NULL);
	pPlayer->Show(pDisplay->GetBackPic(), rcWindow.left, rcWindow.top);

	// ϼ ۸  ۷ Ѵ.
	rcWindowUpdate = rcClientUpdate;
	ClientToScreen(LPPOINT(&rcWindowUpdate));
	ClientToScreen(LPPOINT(&rcWindowUpdate) + 1);

	pDisplay->GetFrontPic()->Blt(
		&rcWindowUpdate, pDisplay->GetBackPic(), &rcWindowUpdate, DDBLT_WAIT, NULL);
}

void cTearsActionWindow::OnKeyDown(WPARAM wParam, LPARAM lParam){
	switch(wParam){
	case VK_LEFT:
		pPlayer->MoveLeftTear();
		break;
	case VK_UP:
		pPlayer->SuspendTear();
		break;
	case VK_RIGHT:
		pPlayer->MoveRightTear();
		break;
	case VK_DOWN:
		pPlayer->DropTear();
		break;
	case VK_ESCAPE:
		pPlayer->Exit();
		break;
	}

}
