#include "Stdinc.h"
#include "cDisplay.h"

#include "cTearsAppWindow.h"
#include "cTearsApp.h"

#include "resource.h"
#include "TOOLMemory.h"

BOOL cTearsAppWindow::ClassRegistered = false;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cTearsAppWindow::cTearsAppWindow(){
	pMainChild = NULL;
}

cTearsAppWindow::~cTearsAppWindow(){
	Destroy();
}

BOOL cTearsAppWindow::RegisterClass(){

	ClassRegistered = cWindow::RegisterClass(
		CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW,
		LoadIcon(hInstance, MAKEINTRESOURCE(IDI_TEARS)),
		LoadCursor(hInstance, MAKEINTRESOURCE(IDC_TEARS)),
		NULL);
	return ClassRegistered;
}

BOOL cTearsAppWindow::Create(){
	DWORD Style = WS_VISIBLE | WS_SYSMENU | WS_POPUP | WS_CLIPCHILDREN;
	DWORD StyleEx = WS_EX_APPWINDOW;
	RECT rcClient = {0, 0, 640, 480};

	AdjustWindowRectEx(&rcClient, Style, FALSE, StyleEx);
	return cWindow::Create(
		StyleEx, // Extended Window Style
		"Ƽ", // Caption
		Style, // Window Style
		CW_USEDEFAULT, CW_USEDEFAULT, // x, y
		rcClient.right - rcClient.left, 
		rcClient.bottom - rcClient.top, // Width, Height
		NULL, // Parent Window
		NULL); // Menu
}

//////////////////////////////////////////////////////////////////////
// Window Prodedure
//////////////////////////////////////////////////////////////////////

LRESULT cTearsAppWindow::Proc(UINT uMsg, WPARAM wParam, LPARAM lParam){
	switch(uMsg){
	case WM_CLOSE:
		if(OnClose()) return 0;
		break;
	case WM_DISPLAYCHANGE:
		OnDisplayChange(wParam, lParam);
		break;
	case WM_SETFOCUS:
		if(pMainChild) pMainChild->SetFocus();
		break;
	}
	return DefProc(uMsg, wParam, lParam);
}

//////////////////////////////////////////////////////////////////////
// Display Change
//////////////////////////////////////////////////////////////////////

void cTearsAppWindow::OnDisplayChange(WPARAM wParam, LPARAM lParam){
	WINDOWPLACEMENT wndpl;
	RECT rcWindow;
	RECT rcClient = {0, 0, 640, 480};

	// ʿ   ũ⸦ Ѵ.
	AdjustWindowRectEx(&rcClient, 
		GetWindowLong(hWnd, GWL_STYLE),
		FALSE,
		GetWindowLong(hWnd, GWL_EXSTYLE));

	//   ġ ľѴ.
	wndpl.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wndpl);
	rcWindow = wndpl.rcNormalPosition;

	wndpl.flags = 0; 
	wndpl.showCmd = SW_SHOWNA; 
    wndpl.ptMaxPosition.x = 0; 
    wndpl.ptMaxPosition.y = 0; 
	SetRect(&wndpl.rcNormalPosition,
		rcWindow.left, rcWindow.top,
		rcWindow.left + rcClient.right - rcClient.left,
		rcWindow.top + rcClient.bottom - rcClient.top);

	SetWindowPlacement(hWnd, &wndpl);
}

//////////////////////////////////////////////////////////////////////
// ̽ ʱȭ ۾
//////////////////////////////////////////////////////////////////////

BOOL cTearsAppWindow::OnClose(){
// α׷     ڿ Ѵ.
//	if(MessageBox(hWnd, "  Ͻðڽϱ?", "Ȯ", MB_YESNO) == IDYES){
		PostQuitMessage(MLEC_EXITAPP);
//		return true;
//	}
	return true;
}

