#ifndef cTearsBoard_H
#define cTearsBoard_H

#include "cActiveObject.h"
#include "cArray2D.h"
#include "cTear.h"
#include "cVisualObject.h"
#include "cList.h"

const int BOARD_WIDTH = 7;
const int BOARD_HEIGHT = 10;

class cTearsBoard : 
	public cActiveObject, 
	public cArray2D<cTear *>,
	public cVisualObject{

	cList<cTear *> TearList;

	int RollDelay;

	cPicture *pBackPicture;
	int Check(int dx, int dy);

public:
	cTearsBoard();
	virtual ~cTearsBoard();

	void Clear(cTear *p);

	void SetBackPicture(cPicture *_pBackPicture){ pBackPicture = _pBackPicture; }
	void SetTear(cTear *pTear);
	int EraseTears();
	void ShiftDown();

	virtual int Act();
	virtual void Show(cPicture *pDestPic, int Left, int Top);
	void ShowEffect(cPicture *pDestPic, int Left, int Top);
	void BreakAll();
	void SetRollDelay(int _RollDelay){ RollDelay = _RollDelay; }
	int GetRollDelay(){ return RollDelay; }

};

#endif
