#include "stdinc.h"
#include "cTearsPlayer.h"
#include "cTearsApp.h"
#include "cVector3d.cpp"

cTearsPlayer::cTearsPlayer(){
	Score = 0;

}

cTearsPlayer::~cTearsPlayer(){

}

void cTearsPlayer::SetStage(int _Stage, sStageDesc *pStageDesc){
	Stage = _Stage;
	StageDesc = *pStageDesc;

	RestTearCount = StageDesc.TearCount;
	yTitle = -StageDesc.pTitlePicture->GetHeight();
	Board.SetRollDelay(StageDesc.RollDelay);

	PrepareStage();
}

cTear *cTearsPlayer::CreateNextTear(){
	cTear *pTear;
	cTear *pNewTear;

	pTear = pNextTears[0];
	pNextTears[0] = pNextTears[1];
	pNextTears[1] = pNextTears[2];

	pNewTear = new cTear;
	pNewTear->SetState(TS_NONE);
	pNewTear->SetKind(rand() % StageDesc.TearKindCount);
	pNewTear->cVector3D<int>::Set(0, 0, 0);
	pNextTears[2] = pNewTear;

	if(pTear){
		pTear->cVector3D<int>::Set(BPToTP(3), BPToTP(0), 0);
		pTear->SetBoard(&Board);
		pTear->AddEnergy(cEnergy(0, StageDesc.DownSpeed, 0));
		pTear->SetState(TS_DOWNING);
	}
	return pTear;
}

void cTearsPlayer::PrepareStage(){
	// ̸⸦ غ
	for(int i = 0; i < 3; i ++)
		pNextTears[i] = NULL;
	CreateNextTear();
	CreateNextTear();
	CreateNextTear();

	pThisTear = NULL;

	Board.Clear(NULL);
	Board.SetBackPicture(StageDesc.pBackPicture);

	State = PS_STAGESTART;
	EraseCount = 0;
//	sndPlaySound("ready.wav", SND_ASYNC); 
}


int cTearsPlayer::Act(){
	Board.Act();

	switch(State){
	case PS_STAGESTART:
		yTitle += 16;
		if(yTitle >= 480){
			State = PS_READY;
		}
		break;
	case PS_DEAD:
		PostQuitMessage(TEC_DEAD);
		return 0;
	case PS_DYING:
		yTitle -= 16;
		if(yTitle < 0){
			State = PS_DEAD;
		}
		return 0;
	case PS_CLEARING:
		yTitle -= 16;
		if(yTitle < 0){
			State = PS_CLEAR;
			PostQuitMessage(TEC_NEXT_STAGE);
		}
		return 0;
	case PS_READY:
		if(RestTearCount == 0){
			State = PS_CLEARING;
			break;
		}
		pThisTear = CreateNextTear();
		if(Board.Get(0, 3) != NULL){
			sndPlaySound("dead.wav", SND_ASYNC); 
			State = PS_DYING;
			yTitle = 480;
		}else{
			State = PS_MOVE;
		}
		break;
	case PS_MOVE:
		MoveTear();
	
		break;
	case PS_ERASE:
		EraseTear();
		break;
	}
	return 0;
}

void cTearsPlayer::MoveTear(){
	if(pThisTear->Act() == TAR_BOTTOM){
		Board.SetTear(pThisTear);
		State = PS_ERASE;
		pThisTear = NULL;//CreateNextTear();
		sndPlaySound("bottom.wav", SND_ASYNC); 
	}
}

void cTearsPlayer::EraseTear(){
	int TearCount;

	if(EraseCount == 0){
		TearCount = Board.EraseTears();
		Score += TearCount * 10;
		RestTearCount -= TearCount;
		if(RestTearCount <= 0){
			RestTearCount = 0;
		}
		if(TearCount == 0){
			State = PS_READY;
			return;
		}else{
			EraseCount ++;
			EraseCount %= 8;
			//  
			sndPlaySound("break.wav", SND_ASYNC); 
		}
	}else{
		EraseCount ++;
		EraseCount %= 8;
		if(EraseCount == 0){
			Board.ShiftDown();
			if(RestTearCount == 0){
				yTitle = 480;
				State = PS_CLEARING;
				//sndPlaySound("clear.wav", SND_ASYNC); 

				Board.BreakAll();
			}
		}

	}

}



void cTearsPlayer::Show(cPicture *pDestPic, int Left, int Top){
	cPicture *pPic;
	RECT rcDest;

	// 带 ׸.
	Board.Show(pDestPic, Left + 180, Top + 40);
	//   Ƽ ׸.
	for(int i = 0; i < 3; i ++){
		if(pNextTears[i]){
			pNextTears[i]->Show(pDestPic, Left + 20 + (2 - i) * 40, Top + 20);
		}
	}

	if(pThisTear){
		pThisTear->Show(pDestPic, Left + 180, Top + 40);
	}

	//   Ѵ.
	HDC hdc;
	HFONT hOldFont, hFont;
	char buff[256];
	if(pDestPic->GetDC(&hdc)){
		hFont = CreateFont(32, 16, 0, 0, 400, FALSE, FALSE, FALSE,
			DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, DEFAULT_PITCH, "");
		hOldFont = (HFONT)SelectObject(hdc, hFont);

		SetTextColor(hdc, RGB(255, 255, 255));
		SetBkMode(hdc, TRANSPARENT);
		sprintf(buff, "%d ", Stage);
		SetTextColor(hdc, RGB(0, 0, 0));
		TextOut(hdc, Left + 506, Top + 26, buff, strlen(buff));
		SetTextColor(hdc, RGB(255, 255, 255));
		TextOut(hdc, Left + 504, Top + 24, buff, strlen(buff));
		sprintf(buff, "%d ", Score); 
		SetTextColor(hdc, RGB(0, 0, 0));
		TextOut(hdc, Left + 506, Top + 146, buff, strlen(buff));
		SetTextColor(hdc, RGB(255, 255, 255));
		TextOut(hdc, Left + 504, Top + 144, buff, strlen(buff));
		sprintf(buff, "%d ", RestTearCount); 
		SetTextColor(hdc, RGB(0, 0, 0));
		TextOut(hdc, Left + 26, Top + 146, buff, strlen(buff));
		SetTextColor(hdc, RGB(255, 255, 255));
		TextOut(hdc, Left + 24, Top + 144, buff, strlen(buff));

		SelectObject(hdc, hOldFont);
		DeleteObject(hFont);
		pDestPic->ReleaseDC(hdc);
	}

	Board.ShowEffect(pDestPic, Left, Top);

	pPic = NULL;
	int yPic;
	switch(State){
	case PS_STAGESTART:
		pPic = StageDesc.pTitlePicture;
		yPic = yTitle;
		if(yPic >= 240 - pPic->GetHeight() / 2){
			yPic = 240 - pPic->GetHeight() / 2;
		}
		break;
	case PS_DYING:
		pPic = StageDesc.pDeadPicture;
		yPic = yTitle;
		if(yPic <= 240 - pPic->GetHeight() / 2){
			yPic = 240 - pPic->GetHeight() / 2;
		}
		break;
	case PS_CLEARING:
		pPic = StageDesc.pClearPicture;
		yPic = yTitle;
		if(yPic <= 240 - pPic->GetHeight() / 2){
			yPic = 240 - pPic->GetHeight() / 2;
		}
		break;
	}

	if(pPic){
		rcDest.left = Left + 320 - pPic->GetWidth() / 2;
		rcDest.top = Top + yPic;
		rcDest.right = rcDest.left + pPic->GetWidth();
		rcDest.bottom = rcDest.top + pPic->GetHeight();

		pDestPic->Blt(&rcDest, pPic, NULL, DDBLT_WAIT | DDBLT_KEYSRC, NULL);
		return;
	}

}


void cTearsPlayer::MoveLeftTear(){
	if(State == PS_MOVE && pThisTear)
		pThisTear->MoveLeft();

}

void cTearsPlayer::SuspendTear(){
	if(State == PS_MOVE && pThisTear)
		pThisTear->SetyEnergy(StageDesc.DownSpeed);
}

void cTearsPlayer::MoveRightTear(){
	if(State == PS_MOVE && pThisTear)
		pThisTear->MoveRight();
}

void cTearsPlayer::DropTear(){
	if(State == PS_MOVE && pThisTear)
		pThisTear->SetyEnergy(PPToTP(40));
}

void cTearsPlayer::Exit(){
	if(State != PS_DYING && State != PS_DEAD){
		sndPlaySound("dead.wav", SND_ASYNC); 
		State = PS_DYING;
		yTitle = 480;
	}

}
