#ifndef cTearsPlayer_H
#define cTearsPlayer_H

#include "cActiveObject.h"
#include "cTearsBoard.h"
#include "cTear.h"


enum ePlayerState{
	PS_STAGESTART, // ߾ ִ 
	PS_READY, // غ
	PS_MOVE, //   
	PS_ERASE, //   
	PS_DYING, // ڰ װ 
	PS_DEAD, // ڰ ׾ 
	PS_CLEARING, //   
	PS_CLEAR //  Ŭ 
};

enum ePlayerMessage{ // ڰ ø̼ǿ  ޽
	PM_PLAYING, //  ϰ 
	PM_CLEARED, //  
	PM_DEAD // ڴ ׾ ִ.
};


struct sStageDesc{ //  
	int TearKindCount; //  
	int TearCount; //   
	int DownSpeed; //  ӵ
	int RollDelay; // Ƽ ȸϴ ӵ
	cPicture *pBackPicture; //  ׸ ȣ
	cPicture *pTitlePicture;
	cPicture *pClearPicture;
	cPicture *pDeadPicture;
};

class cTearsPlayer : public cActiveObject{
protected:
	ePlayerState State;

	cTearsBoard Board;
	cTear *pNextTears[3];
	cTear *pThisTear;

	int RestTearCount;
	int Score;
	int Stage;

	int EraseCount;
	int yTitle;
	int Count;

	sStageDesc StageDesc;

	void PrepareStage();
	cTear *CreateNextTear();
	void MoveTear();
	void EraseTear();


public:
	cTearsPlayer();
	~cTearsPlayer();

	void SetStage(int Stage, sStageDesc *pStageDesc);

	virtual int Act();
	void Show(cPicture *pDestPic, int Left, int Top);

	void MoveLeftTear();
	void SuspendTear();
	void MoveRightTear();
	void DropTear();
	void Exit();


};

#endif