// cTileMap.cpp: implementation of the cTileMap class.
//
//////////////////////////////////////////////////////////////////////

#include <windows.h>
#include "cTileMap.h"
#include "cArray2D.cpp"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template <class cTile, class cSpot>
cTileMap<cTile, cSpot>::cTileMap(){
	Tiles = NULL;
}

template <class cTile, class cSpot>
cTileMap<cTile, cSpot>::~cTileMap(){
	Destroy();
}

// Ÿ  
template <class cTile, class cSpot>
bool cTileMap<cTile, cSpot>::Create(WORD _Height, WORD _Width, cTile *_Tiles, WORD _TileCount){

	int i;

	TileCount = _TileCount;

	Tiles = new cTile[TileCount];
	if(!Tiles) return false; 
	for(i = 0; i < TileCount; i ++)
		Tiles[i] = _Tiles[i];

//	ZeroMemory(Tiles, sizeof(cTile) * TileCount);

	return cArray2D<cSpot>::Create(_Height, _Width);
}

template <class cTile, class cSpot>
void cTileMap<cTile, cSpot>::Destroy(){
	cArray2D<cSpot>::Destroy();
	if(Tiles){
		delete [] Tiles;
		Tiles = NULL;
	}
}














template<class cTile, class cSpot>
void cTileMap<cTile, cSpot>::SetPicture(cPicture *_pBGPic){
	DDCOLORKEY ddck;

	pBGPic = _pBGPic;
	ddck.dwColorSpaceLowValue = 0;
	ddck.dwColorSpaceHighValue = 0;
	pBGPic->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

template<class cTile, class cSpot>
void cTileMap<cTile, cSpot>::ShowBack(cPicture *pDestPic,
	int Left, int Top, LPRECT pSrcRect){
// pDestPic Left, Top ġ  pSrcRect κ ׷.
	RECT rcDest, rcSrc;
	int TileNo;
	int xBegin, xEnd, yBegin, yEnd, ySrc, xSrc;
	
	xBegin = pSrcRect->left / 32;
	if(xBegin < 0) xBegin = 0;
	xEnd = pSrcRect->right / 32;
	if(xEnd >= GetWidth()) xEnd = GetWidth() - 1;
	yBegin = pSrcRect->top / 32;
	if(yBegin < 0) yBegin = 0;
	yEnd = pSrcRect->bottom / 32;
	if(yEnd >= GetHeight()) yEnd = GetHeight() - 1;

	ySrc = yBegin;
	rcDest.top = Top - (pSrcRect->top % 32);
	rcDest.bottom = rcDest.top + 32;
	while(ySrc <= yEnd){
		xSrc = xBegin;
		rcDest.left = Left - (pSrcRect->left % 32);
		rcDest.right = rcDest.left + 32;
		while(xSrc <= xEnd){
			// 
//			AssembleTile(pDestPic, &rcDest, ySrc, xSrc);

			TileNo = Get(ySrc, xSrc).GetTileNo();
			// ߽  ׷.
			if(Get(ySrc, xSrc).GetObject() != NULL)
				TileNo = 3;
			rcSrc.left = TileNo << 5; 
			rcSrc.top = 0;
			rcSrc.right = rcSrc.left + 32; 
			rcSrc.bottom = rcSrc.top + 32;
			pDestPic->Blt(&rcDest, pBGPic, &rcSrc, DDBLT_WAIT, 0);

			xSrc ++;
			rcDest.left += 32;
			rcDest.right += 32;
		}
		ySrc ++;
		rcDest.top += 32;
		rcDest.bottom += 32;
	}
}

template<class cTile, class cSpot>
void cTileMap<cTile, cSpot>::ShowFront(cPicture *pDestPic, int Left, int Top, LPRECT pSrcRect){
	// δ  
}
