/*
	template class cVector3D

*/

#ifndef cVector3D_H
#define cVector3D_H

template<class Type> 
class cVector3D{
public:
	Type x, y, z;

	cVector3D();
	cVector3D(const cVector3D &a){ x = a.x; y = a.y; z = a.z; }
	cVector3D(int _x, int _y, int _z){ x = _x; y = _y; z = _z; }
	virtual ~cVector3D();

	void Set(int _x, int _y, int _z){ x = _x; y = _y; z = _z; }
//	cVector3D &operator=(cVector3D &a){ x = a.x; y = a.y; z = a.z; return *this; }
	// Vector operations
	cVector3D &operator =(const cVector3D &a){ x = a.x; y = a.y; z = a.z; return *this; }
	void operator +=(const cVector3D &a){ x += a.x; y += a.y; z += a.z; }
	void operator -=(const cVector3D &a){ x -= a.x; y -= a.y; z -= a.z; }
	void operator *=(const cVector3D &a){ x *= a.x; y *= a.y; z *= a.z; }

	// Scala Operations
	void operator *=(Type s){ x *= s; y *= s; z *= s; }
	void operator /=(Type s){ x /= s; y /= s; z /= s; }
	void operator +=(Type s){ x += s; y += s; z += s; }
	void operator -=(Type s){ x -= s; y -= s; z -= s; }
	
	inline operator Type();
	inline Type GetLength();
	double GetXYAngle();

	cVector3D operator-(){ return cVector3D(-x, -y, -z); }
/*

	// Compare
	friend bool operator==(const cVector3D &a, const cVector3D &b){ 
		if(a.x == b.x && a.y == b.y && a.z == b.z) return true; return false; } 
	friend bool operator!=(const cVector3D &a, const cVector3D &b){ 
		if(a.x != b.x || a.y != b.y || a.z != b.z) return true; return false; }
	friend bool operator<(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() < b.GetLength()) return true; return false; }
	friend bool operator<=(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() <= b.GetLength()) return true; return false; }
	friend bool operator>(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() > b.GetLength()) return true; return false; }
	friend bool operator>=(const cVector3D &a, const cVector3D &b){ 
		if(a.GetLength() >= b.GetLength()) return true; return false; }
	*/
	friend cVector3D operator+(const cVector3D &a, const cVector3D &b){
		return cVector3D(a.x + b.x, a.y + b.y, a.z + b.z); }
	friend cVector3D operator-(const cVector3D &a, const cVector3D &b){
		return cVector3D(a.x - b.x, a.y - b.y, a.z - b.z); }
	friend cVector3D operator*(const cVector3D &a, int s){
		cVector3D r;
		r = a; r *= s; return r;
	}
	friend cVector3D operator/(const cVector3D &a, int s){
		cVector3D r;
		r = a; r /= s; return r;
	}

};




#endif
