// cWindow.cpp: implementation of the cWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "cWindow.h"

//   ʱȭ Ѵ.
cWindow *cWindow::pThisObject = NULL;
HINSTANCE cWindow::hInstance = NULL;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

cWindow::cWindow(){
	hWnd = NULL;
}

cWindow::~cWindow(){
	Destroy();
}

//////////////////////////////////////////////////////////////////////
// Window Creation
//////////////////////////////////////////////////////////////////////

BOOL cWindow::RegisterClass(DWORD Style, HICON hIcon, 
				   HCURSOR hCursor, HBRUSH hbrBackground, 
				   LPCTSTR lpszMenuName){
	WNDCLASSEX wc;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = Style;
	wc.lpfnWndProc = DefaultProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = hIcon;
	wc.hCursor = hCursor;
	wc.hbrBackground = hbrBackground;
	wc.lpszMenuName = lpszMenuName;
	wc.lpszClassName = GetClassName();
    wc.hIconSm = hIcon;

	return RegisterClassEx(&wc) != 0;
}

//////////////////////////////////////////////////////////////////////
// Window Creation
//////////////////////////////////////////////////////////////////////

BOOL cWindow::Create(DWORD dwExStyle, LPCTSTR lpWindowName, 
	DWORD dwStyle, int x, int y, int nWidth, int nHeight, 
	cWindow *pParent, HMENU hMenu){

	if(!IsClassRegistered())
		if(!RegisterClass()) return NULL;

	pThisObject = this;
	hWnd = ::CreateWindowEx(
		dwExStyle, GetClassName(), lpWindowName, 
		dwStyle, x, y, nWidth, nHeight, 
		*pParent, hMenu, hInstance, NULL);

	return hWnd != NULL;
}

void cWindow::Destroy(){
	if(hWnd){
		::DestroyWindow(hWnd);
		hWnd = NULL;
	}
}
//////////////////////////////////////////////////////////////////////
// Window Procedure
//////////////////////////////////////////////////////////////////////

LRESULT CALLBACK cWindow::DefaultProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam){
// *   Լ̹Ƿ     ִ.
//  ڵ óϴ cWindowü ã WindowProc ȣ ش.
	cWindow *pObj;
	
	pObj = (cWindow *)::GetWindowLong(hWnd, GWL_USERDATA);
	if(pObj == NULL){ // ü ó  Ǿ 
		SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThisObject);
		pObj = pThisObject;
		pObj->hWnd = hWnd;
	}
	return pObj->Proc(uMsg, wParam, lParam);
}



//////////////////////////////////////////////////////////////////////
// Window Size and Position
//////////////////////////////////////////////////////////////////////
/*
SIZE cWindow::GetNormalClientSize(){
// 찡 ּȭ Ǿ  GetClientRectδ 
//   ũ⸦   Ƿ 
// AdjustWindowRectEx Լ ̿Ѵ.
	WINDOWPLACEMENT wndpl;
	RECT rcWindow, rcRequired;
	SIZE sz;

	//   ġ ľѴ.
	wndpl.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(hWnd, &wndpl);
	rcWindow = wndpl.rcNormalPosition;
	rcRequired = rcWindow;
	// required  window Ŭ̾Ʈ  ʿ  ũ⸦ 
	AdjustWindowRectEx(&rcRequired, GetWindowLong(hWnd, GWL_STYLE),
		FALSE, GetWindowLong(hWnd, GWL_EXSTYLE));
	sz.cx = rcWindow.right - (rcRequired.right - rcWindow.right)
		- (rcWindow.left + rcWindow.left - rcRequired.left);
	sz.cy = rcWindow.bottom - (rcRequired.bottom - rcWindow.bottom)
		- (rcWindow.top + rcWindow.top - rcRequired.top);

	return sz;
}
*/
//////////////////////////////////////////////////////////////////////
// Static Window Operations
//////////////////////////////////////////////////////////////////////
cWindow *cWindow::GetTopLevelParent(){
	HWND hwnd;

	hwnd = hWnd;

	while(::GetParent(hwnd)) 
		hwnd = ::GetParent(hwnd);
	return GetWindow(hwnd);
}

