// cXTileMap.cpp: implementation of the cXTileMap class.
//
//////////////////////////////////////////////////////////////////////

#include "cXTileMap.h"
#include "cTileMap.cpp"

const int xySeek[16] = {
	-1, 0, 0, -1, 1, 0, 0, 1, 
	-1, 0, 0, -1, 1, 0, 0, 1
};

const int AroundTileIndices[4] = {
	0, 4, 8, 12
};
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

template<class cTile, class cSpot>
cXTileMap<cTile, cSpot>::cXTileMap(){

}

template<class cTile, class cSpot>
cXTileMap<cTile, cSpot>::~cXTileMap(){

}

template<class cTile, class cSpot>
void cXTileMap<cTile, cSpot>::SetPicture(cPicture *_pBGPic){

	pBGPic = _pBGPic;
	DDCOLORKEY ddck;
	ddck.dwColorSpaceLowValue = 0;
	ddck.dwColorSpaceHighValue = 0;
	pBGPic->SetColorKey(DDCKEY_SRCBLT, &ddck);
//	MessageBox(NULL, " ", NULL, MB_OK);
}

template<class cTile, class cSpot>
void cXTileMap<cTile, cSpot>::ShowBack(cPicture *pDestPic,
	int Left, int Top, LPRECT pSrcRect){
// pDestPic Left, Top ġ  pSrcRect κ ׷.
	RECT rcDest;
	int xBegin, xEnd, yBegin, yEnd, ySrc, xSrc;
	
	xBegin = pSrcRect->left / 32;
	if(xBegin < 0) xBegin = 0;
	xEnd = pSrcRect->right / 32;
	if(xEnd >= GetWidth()) xEnd = GetWidth() - 1;
	yBegin = pSrcRect->top / 32;
	if(yBegin < 0) yBegin = 0;
	yEnd = pSrcRect->bottom / 32;
	if(yEnd >= GetHeight()) yEnd = GetHeight() - 1;

	ySrc = yBegin;
	rcDest.top = Top - (pSrcRect->top % 32);
	rcDest.bottom = rcDest.top + 32;
	while(ySrc <= yEnd){
		xSrc = xBegin;
		rcDest.left = Left - (pSrcRect->left % 32);
		rcDest.right = rcDest.left + 32;
		while(xSrc <= xEnd){
			// 
			AssembleTile(pDestPic, &rcDest, ySrc, xSrc);
			xSrc ++;
			rcDest.left += 32;
			rcDest.right += 32;
		}
		ySrc ++;
		rcDest.top += 32;
		rcDest.bottom += 32;
	}
}

template<class cTile, class cSpot>
void cXTileMap<cTile, cSpot>::AssembleTile(cPicture *pDestPic, LPRECT prcDest, int y, int x){

//   Ÿ Ͽ  .
	int Center; //, Base;
//	int SeekIdx, Count;
	RECT rcSrc;

	if(y < 1 || x < 1 || y >= Height - 1 || x >= Width - 1)
		return;

	Center = Get(y, x).GetTileNo();

	// ߽  ׷.
	rcSrc.left = Center << 5; 
	rcSrc.top = 0;
	rcSrc.right = rcSrc.left + 32; 
	rcSrc.bottom = rcSrc.top + 32;
	pDestPic->Blt(prcDest, pBGPic, &rcSrc, DDBLT_WAIT, 0);
/*
	// ߽ Ÿ ֺŸ ˻Ͽ  ʿ Ÿ ã´.
	for(SeekIdx = 0; SeekIdx < 8; SeekIdx += 2){
		Base = Get(y + xySeek[SeekIdx + 1], x + xySeek[SeekIdx]).BackTile;
		if(Base <= Center) // ֺ Ÿ 켱  ٸ  Ÿ ˻Ѵ.
			continue;
		//  Ÿ  ŽѴ.
		Count = 2;
		while(Get(y + xySeek[SeekIdx + Count + 1], x + xySeek[SeekIdx + Count]).BackTile == Base 
			&& Count < 8)
			Count += 2;
		rcSrc.left =  (AroundTileIndices[(Count >> 1) - 1] + (SeekIdx >> 1)) << 5;
		rcSrc.top = 32;// + (Base << 5);
		rcSrc.right = rcSrc.left + 32;
		rcSrc.bottom = rcSrc.top + 32;
		// Center   ׸ Ѵ.
		pDestPic->Blt(prcDest, pBGPic, &rcSrc, DDBLT_WAIT | DDBLT_KEYSRC, NULL);
		SeekIdx += Count - 2;
	}
*/
}

template<class cTile, class cSpot>
void cXTileMap<cTile, cSpot>::ShowFront(cPicture *pDestPic, int Left, int Top, LPRECT pSrcRect){
	// δ  
}
