#ifndef cXTileMap_H
#define cXTileMap_H

#include "cTileMap.h"
#include "cPicture.h"

struct sXTileDesc{
	int BaseTileCount;
	int XTileCount;
	int BaseTile;
};

template<class cTile, class cSpot>
class cXTileMap : public cTileMap<cTile, cSpot>{
protected:
	cPicture *pBGPic;

	void AssembleTile(cPicture *pDestPic, LPRECT prcDest, int y, int x);

public:
	cXTileMap();
	virtual ~cXTileMap();

	void SetPicture(cPicture *_pBGPic);

	void ShowBack(cPicture *pDestPic, int Left, int Top, LPRECT pSrcRect);
	void ShowFront(cPicture *pDestPic, int Left, int Top, LPRECT pSrcRect);

};

#endif
