#define D3D_OVERLOADS
#include <stdio.h>
#include "ase.h"
#include "texture.h"
#include "d3dmath.h"

char	ReadString[64];
static FileMaterial *Material_Info;
static FileMesh	 *Mesh_Info;
unsigned int BlockCnt = 0;

// Internal Func //
char *EraseQuotation(char *String);
static char *strcopy (char *src);


Vanesa ReadAse(LPDIRECT3DDEVICE7    pd3dDevice)
{
	int Material_Counter = 0;
	int ki = 0;
	FILE	*f;
	FileMesh *Mesh_New_Info, *BridgeMesh;
	FileMesh	tMesh;
	Vanesa first_v;
	
	f = fopen("a4_pose1.ase", "rb");
	while(1)
	{
		if(fscanf(f, "%s", &ReadString) == EOF) break;

		if(strcmp(ReadString, "*MATERIAL_COUNT") == 0)
		{
			fscanf(f, "%d", &Material_Counter); 
			Material_Info = (FileMaterial *)malloc(sizeof(FileMaterial) * Material_Counter);
		}	

		if(strcmp(ReadString, "*MATERIAL") == 0)
		{
            fscanf(f, "%d", &ki);
		
			*(Material_Info + ki) = MaterialObject(pd3dDevice, f);
			
		}

		if(strcmp(ReadString, "*GEOMOBJECT") == 0) 
		{
			Mesh_New_Info = (FileMesh *)malloc(sizeof(FileMesh));
			fscanf(f, "%s", ReadString);
			BlockCnt++;
			tMesh = MeshObject(f);
			
	Mesh_New_Info->Cube = tMesh.Cube;	
	Mesh_New_Info->Index = tMesh.Index; 	
	Mesh_New_Info->numverts = tMesh.numverts; 	 
	Mesh_New_Info->numfaces =tMesh.numfaces; 
	Mesh_New_Info->Texture_Flags = tMesh.Texture_Flags; 
	Mesh_New_Info->Material_ID = tMesh.Material_ID; 
	Mesh_New_Info->Next =NULL;

			if(Mesh_Info == NULL)
			{
				Mesh_Info = Mesh_New_Info;
				BridgeMesh = Mesh_Info;
			}
			else
			{
				BridgeMesh->Next = Mesh_New_Info;
				BridgeMesh = Mesh_New_Info;
			} 
		}
	}
	fclose(f);
	first_v.MeyMat = Material_Info;
	first_v.MeyMesh = Mesh_Info;
	first_v.total_matr = Material_Counter;
	return first_v;
}

FileMaterial MaterialObject(LPDIRECT3DDEVICE7  pd3dDevice, FILE *f)
{
	FileMaterial	Material_Primary; 
	
    Material_Primary.Number			=	0;
	Material_Primary.Name			=	NULL;
	Material_Primary.Shading		=	D3DSHADE_GOURAUD;
	Material_Primary.Flags			=	0;
	Material_Primary.TextureName	=	NULL;
	Material_Primary.lpD3DSurface	=	NULL;

	ZeroMemory( &Material_Primary.Material, sizeof(D3DMATERIAL7) );
    Material_Primary.Material.dcvDiffuse.r = Material_Primary.Material.dcvAmbient.r = 1.0f;
    Material_Primary.Material.dcvDiffuse.g = Material_Primary.Material.dcvAmbient.g = 1.0f;
    Material_Primary.Material.dcvDiffuse.b = Material_Primary.Material.dcvAmbient.b = 1.0f;
    Material_Primary.Material.dcvDiffuse.a = Material_Primary.Material.dcvAmbient.a = 1.0f;

	while(TRUE) 
	{
		fscanf(f, "%s", ReadString);
		if(strcmp(ReadString, "}") == 0) break;

		if(strcmp(ReadString, "*MATERIAL_NAME") == 0) 
		{
			fscanf(f, "%s", ReadString);
			Material_Primary.Name = strcopy(ReadString);			
		}

		if(strcmp(ReadString, "*MATERIAL_AMBIENT") == 0) 
		{
			fscanf(f, "%f", &(Material_Primary.Material.dcvAmbient.r));
			fscanf(f, "%f", &(Material_Primary.Material.dcvAmbient.g));
			fscanf(f, "%f", &(Material_Primary.Material.dcvAmbient.b));
		}

		if(strcmp(ReadString, "*MATERIAL_DIFFUSE") == 0) 
		{
			fscanf(f, "%f", &(Material_Primary.Material.dcvDiffuse.r));
			fscanf(f, "%f", &(Material_Primary.Material.dcvDiffuse.g));
			fscanf(f, "%f", &(Material_Primary.Material.dcvDiffuse.b));
		}

		if(strcmp(ReadString, "*MATERIAL_SPECULAR") == 0) 
		{
			fscanf(f, "%f", &(Material_Primary.Material.dcvSpecular.r));
			fscanf(f, "%f", &(Material_Primary.Material.dcvSpecular.g));
			fscanf(f, "%f", &(Material_Primary.Material.dcvSpecular.b));
		}
		
		//if(strcmp(ReadString, "*MATERIAL_SHINE") == 0)
		//	fscanf(f, "%f", &(Material_Primary->Material.dcvEmissive));

		//if(strcmp(ReadString, "*MATERIAL_SHINESTRENGTH") == 0)
		//	fscanf(f, "%f", &(Material_Primary->Material.dvPower));

		if(strcmp(ReadString, "*MATERIAL_SHADING") == 0) 
		{
			fscanf(f, "%s", ReadString);
			if(strcmp(ReadString, "Phong") == 0) 
			Material_Primary.Shading = 1;
		}

		if(strcmp(ReadString, "*MATERIAL_TWOSIDED") == 0)
		Material_Primary.Flags |= MATERIAL_TWOSIDED;


		// Ʈ о ؽĸ Ѵ.
		if(strcmp(ReadString, "*BITMAP") == 0) 
		{
			fscanf(f, "%s", ReadString);
			Material_Primary.TextureName = EraseQuotation(ReadString);
			Material_Primary.Flags		 = 1;
			Material_Primary.lpD3DSurface = CreateTexture(pd3dDevice, Material_Primary.TextureName);
		}
			// ũ Ʈ .
	
	}

	return Material_Primary;	
}

FileMesh MeshObject(FILE *f)
{

D3DVERTEX 	*Cube;
WORD 		*Index;
DWORD 		numverts, numfaces, numtex_vertex = 0;
DWORD	 	Texture_Flags = 0;
int 		Material_ID;
D3DMATRIX	MeshMatrix;
UVlist		*TextureUVlist;
FileMesh TouchMesh;
DWORD local_counter;
unsigned long rabbit = 0;
D3DVECTOR	TempVec;
D3DVECTOR	u, v, n;
unsigned int	a, b, c, Temp = 0;
float VertexTemp;


	while(BlockCnt) 
	{
		fscanf(f, "%s", ReadString);

		if(strcmp(ReadString, "{") == 0)
			BlockCnt++;

		if(strcmp(ReadString, "}") == 0)
			BlockCnt--;
		
		if(strcmp(ReadString, "*TM_ROW0") == 0) 
		{
			fscanf(f, "%f", &MeshMatrix._11);
			fscanf(f, "%f", &MeshMatrix._13);
			fscanf(f, "%f", &MeshMatrix._12);
		}

		if(strcmp(ReadString, "*TM_ROW1") == 0) 
		{
			fscanf(f, "%f", &MeshMatrix._31);
			fscanf(f, "%f", &MeshMatrix._33);
			fscanf(f, "%f", &MeshMatrix._32);
		}

		if(strcmp(ReadString, "*TM_ROW2") == 0) 
		{
			fscanf(f, "%f", &MeshMatrix._21);
			fscanf(f, "%f", &MeshMatrix._23);
			fscanf(f, "%f", &MeshMatrix._22);
		}
		
		if(strcmp(ReadString, "*TM_ROW3") == 0) 
		{
			fscanf(f, "%f", &MeshMatrix._41);
			fscanf(f, "%f", &MeshMatrix._42);
			fscanf(f, "%f", &MeshMatrix._43);

			//  Ѵ.
//			D3DMath_MatrixInvert(MeshMatrix, MeshMatrix);
		}

		if(strcmp(ReadString, "*MESH_NUMVERTEX") == 0) 
		{
			fscanf(f, "%d", &numverts);			
		}

		if(strcmp(ReadString, "*MESH_NUMFACES") == 0) 
		{
			fscanf(f, "%d", &numfaces);			
		}
		if(strcmp(ReadString, "*MESH_VERTEX_LIST") == 0)
		{			
			local_counter = 0;
			Cube = (D3DVERTEX *)malloc(sizeof(D3DVERTEX)*numverts);
			ZeroMemory(Cube, sizeof(D3DVERTEX)*numverts);
			while(TRUE)
			{
				fscanf(f, "%s", ReadString);
				if(strcmp(ReadString, "}") == 0) break;
                local_counter++;
				if(strcmp(ReadString, "*MESH_VERTEX") == 0) 
				{
					fscanf(f, "%d", &local_counter );
					fscanf(f, "%f", &(Cube + local_counter)->x);
					fscanf(f, "%f", &(Cube + local_counter)->y);
					fscanf(f, "%f", &(Cube + local_counter)->z);
				}
			}
		} 

		if(strcmp(ReadString, "*MESH_FACE_LIST") == 0) 
		{
			local_counter = 0;
			Index = (WORD *)malloc(sizeof(WORD) * numfaces * 3);			
			while(TRUE) 
			{
				fscanf(f, "%s", ReadString);
				if(strcmp(ReadString, "}") == 0) break;
				if(strcmp(ReadString, "*MESH_FACE") == 0) 
				{
					fscanf(f, "%s", ReadString);// Face Index

					fscanf(f, "%s", ReadString);// A
					fscanf(f, "%d", (Index + local_counter));
					local_counter++;
					fscanf(f, "%s", ReadString);// B
					fscanf(f, "%d", (Index + local_counter));
					local_counter++;
					fscanf(f, "%s", ReadString);// C
					fscanf(f, "%d", (Index + local_counter));
					local_counter++;
				}

			//	 face ͸ ٲ° ӵ
			//	ڵ ȭ  κ ۼ ʴ´.
			//	  ٸ ǥϴ  
			//	ϴٸ ٸ  ҷ鿩  
			//	ɶ  κп ü ٿ ȿ   
			//	ְ Ѵ.
			//	if(strcmp(ReadString, "*MESH_MTLID") == 0) 
			//	{
			//	}
			
			} // while end

			//Normal Vector init
/*			if(strcmp(ReadString, "*MESH_VERTEXNORMAL") == 0)
			{
				fscanf(f, "%d", &Temp);
				fscanf(f, "%f", &Cube[Temp].nx);
				fscanf(f, "%f", &Cube[Temp].ny);
				fscanf(f, "%f", &Cube[Temp].nz);
			} */
		/*	for(rabbit = 0; rabbit < numverts; rabbit++)
			{
				Cube[rabbit].nx = 0;
				Cube[rabbit].ny = 0;
				Cube[rabbit].nz = 0;
			}

			for(rabbit = 0; rabbit < numfaces; rabbit++)
			{
				u.x = Cube[Index[2 + (rabbit*3)]].x - Cube[Index[1 + (rabbit*3)]].x;
				u.y = Cube[Index[2 + (rabbit*3)]].y - Cube[Index[1 + (rabbit*3)]].y;
				u.z = Cube[Index[2 + (rabbit*3)]].z - Cube[Index[1 + (rabbit*3)]].z;

				v.x = Cube[Index[2 + (rabbit*3)]].x - Cube[Index[rabbit*3]].x;
				v.y = Cube[Index[2 + (rabbit*3)]].y - Cube[Index[rabbit*3]].y;
				v.z = Cube[Index[2 + (rabbit*3)]].z - Cube[Index[rabbit*3]].z;								
				
				n = Normalize( CrossProduct( u, v ) );
				
				Cube[Index[rabbit*3]].nx += n.x;
				Cube[Index[rabbit*3]].ny += n.y;
				Cube[Index[rabbit*3]].nz += n.z;
 				
				Cube[Index[(rabbit*3) + 1]].nx += n.x;
				Cube[Index[(rabbit*3) + 1]].ny += n.y;
				Cube[Index[(rabbit*3) + 1]].nz += n.z;
				
				Cube[Index[(rabbit*3) + 2]].nx += n.x;
				Cube[Index[(rabbit*3) + 2]].ny += n.y;
				Cube[Index[(rabbit*3) + 2]].nz += n.z;
			}
			for(rabbit = 0; rabbit < numverts; rabbit++) 
			{
				n.x = Cube[rabbit].nx;
				n.y = Cube[rabbit].ny;
				n.z = Cube[rabbit].nz;

				n = Normalize( n );

				Cube[rabbit].nx = n.x;
				Cube[rabbit].ny = n.y;
				Cube[rabbit].nz = n.z;
			}   */
		} 

		// ؽ ǥ ó
		if(strcmp(ReadString, "*MESH_NUMTVERTEX") == 0) 
		{
			fscanf(f, "%d", &numtex_vertex);
			TextureUVlist = (UVlist *)malloc( sizeof(UVlist) * numtex_vertex);
		} 
		if(strcmp(ReadString, "*MESH_TVERT") == 0) 
		{
			// ؽ ȣ skipѴ.
			fscanf(f, "%d", &local_counter);
			fscanf(f, "%f", &TextureUVlist[ local_counter ].u);
			fscanf(f, "%f", &TextureUVlist[ local_counter ].v);

		} 
		
		if(strcmp(ReadString, "*MESH_TFACELIST") == 0) 
		{
			rabbit = 0;
			
			while(TRUE) 
			{
				fscanf(f, "%s", ReadString);
				if(strcmp(ReadString, "}") == 0) break;

				if(strcmp(ReadString, "*MESH_TFACE") == 0) 
				{
					fscanf(f, "%s", ReadString);// Face Index

					fscanf(f, "%d", &a);
					fscanf(f, "%d", &b);
					fscanf(f, "%d", &c);
					
					// Ʈ   Ʒ Ųٷ ǹǷ, 1 - v ش.
					Cube[ Index[(rabbit*3)] ].tu = TextureUVlist[a].u;
					Cube[ Index[(rabbit*3)] ].tv = 1.0f - TextureUVlist[a].v;

					Cube[ Index[(rabbit*3) + 1] ].tu = TextureUVlist[b].u;
					Cube[ Index[(rabbit*3) + 1] ].tv = 1.0f - TextureUVlist[b].v;

					Cube[ Index[(rabbit*3) + 2] ].tu = TextureUVlist[c].u;
					Cube[ Index[(rabbit*3) + 2] ].tv = 1.0f - TextureUVlist[c].v;
					rabbit++;
				}
			}
			free(TextureUVlist);
		}  

		// Material
		if(strcmp(ReadString, "*MATERIAL_REF") == 0) 
		{
			fscanf(f, "%d", &Material_ID);
			if(Material_Info[Material_ID].Flags == 1)
			Texture_Flags = 1;
		}
		
		//  ؽ İ  Ѵ.	 
	}

	/*for(rabbit = 0; rabbit < numverts; rabbit++) 
		{
			TempVec.x = Cube[rabbit].x * MeshMatrix._11 +
				    Cube[rabbit].y * MeshMatrix._21 +
				    Cube[rabbit].z * MeshMatrix._31 + 
				    MeshMatrix._41;

			TempVec.y = Cube[rabbit].x * MeshMatrix._12 +
				    Cube[rabbit].y * MeshMatrix._22 +
		 	            Cube[rabbit].z * MeshMatrix._32 + 
				    MeshMatrix._42;

			TempVec.z = Cube[rabbit].x * MeshMatrix._13 +
				    Cube[rabbit].y * MeshMatrix._23 +
				    Cube[rabbit].z * MeshMatrix._33 + 
				    MeshMatrix._43;

			Cube[rabbit].x = TempVec.x;
			Cube[rabbit].y = TempVec.y;
			Cube[rabbit].z = TempVec.z;
		} 
			for(rabbit = 0; rabbit < numverts; rabbit++)
			{
				Cube[rabbit].nx = 0;
				Cube[rabbit].ny = 0;
				Cube[rabbit].nz = 0;
			} */

			for(rabbit = 0; rabbit < numfaces; rabbit++)
			{
				u.x = Cube[Index[2 + (rabbit*3)]].x - Cube[Index[1 + (rabbit*3)]].x;
				u.y = Cube[Index[2 + (rabbit*3)]].y - Cube[Index[1 + (rabbit*3)]].y;
				u.z = Cube[Index[2 + (rabbit*3)]].z - Cube[Index[1 + (rabbit*3)]].z;

				v.x = Cube[Index[2 + (rabbit*3)]].x - Cube[Index[rabbit*3]].x;
				v.y = Cube[Index[2 + (rabbit*3)]].y - Cube[Index[rabbit*3]].y;
				v.z = Cube[Index[2 + (rabbit*3)]].z - Cube[Index[rabbit*3]].z;								
				
				n = Normalize( CrossProduct( u, v ) );
				
				Cube[Index[rabbit*3]].nx += n.x;
				Cube[Index[rabbit*3]].ny += n.y;
				Cube[Index[rabbit*3]].nz += n.z;
 				
				Cube[Index[(rabbit*3) + 1]].nx += n.x;
				Cube[Index[(rabbit*3) + 1]].ny += n.y;
				Cube[Index[(rabbit*3) + 1]].nz += n.z;
				
				Cube[Index[(rabbit*3) + 2]].nx += n.x;
				Cube[Index[(rabbit*3) + 2]].ny += n.y;
				Cube[Index[(rabbit*3) + 2]].nz += n.z;
			}
			for(rabbit = 0; rabbit < numverts; rabbit++) 
			{
				n.x = Cube[rabbit].nx;
				n.y = Cube[rabbit].ny;
				n.z = Cube[rabbit].nz;

				n = Normalize( n );

				Cube[rabbit].nx = n.x;
				Cube[rabbit].ny = n.y;
				Cube[rabbit].nz = n.z;
			}   

			for(local_counter = 0; local_counter <numverts; local_counter++)
			{
				VertexTemp			  = Cube[local_counter].z;
				Cube[local_counter].z = -Cube[local_counter].y;
				Cube[local_counter].y = VertexTemp;
			//	VertexTemp			  = Cube[local_counter].x;
			//	Cube[local_counter].x = -Cube[local_counter].z;
			//	Cube[local_counter].z = VertexTemp;
			}
TouchMesh.Matrix_j  =   MeshMatrix;
TouchMesh.Cube 		=	Cube;
TouchMesh.Index 	=	Index;
TouchMesh.numverts 	= 	numverts; 
TouchMesh.numfaces	=	numfaces; 
TouchMesh.Texture_Flags = 	Texture_Flags;
TouchMesh.Material_ID   =	Material_ID;

return TouchMesh;
}


char *EraseQuotation(char *String)
{
	char	*TempStr;
	unsigned int	SrcPos = 0, TarPos = 0;
	
	if((TempStr = (char*)malloc(strlen(String) + 1)) == NULL)
		return NULL;

	while(String[SrcPos] != NULL) {
			
		if(String[SrcPos] == '"') {
			SrcPos++;
			continue;
		}

		TempStr[TarPos++] = String[SrcPos++];
	}
	
	TempStr[TarPos] = '\0';
	return TempStr;
}

static char *strcopy (char *src)
{
	char *temp;

	if ((temp = (char*)malloc(strlen (src) + 1)) == NULL) 
		return NULL;

	strcpy (temp, src);
	return temp;
}
