//-----------------------------------------------------------------------------
// File: Render.cpp
//
// Desc: Simple tutorial code to draw a 3D scene.
//
// Copyright (c) 1998-1999 Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------

#define STRICT
#define D3D_OVERLOADS
#include <math.h>
#include <d3d.h>
#include "ase.h"
#include "d3dutil.h"

//-----------------------------------------------------------------------------
// Defines, constants, and global variables
//-----------------------------------------------------------------------------
#define CONE_HEIGHT        3.0f
#define CONE_RADIUS        1.0f
#define NUM_CONE_SIDES     20
#define NUM_CONE_VERTICES (NUM_CONE_SIDES+1)
HRESULT SetViewMatrix( D3DMATRIX& mat, D3DVECTOR& vFrom, D3DVECTOR& vAt,
                       D3DVECTOR& vWorldUp );

D3DVERTEX g_pvCone[NUM_CONE_VERTICES]; // untransformed tri fan with flexible verts


#define g_PI 3.1415926283


#define NUM_CONES 10
D3DMATRIX g_matConePos[NUM_CONES];
FLOAT     g_afConeColor[NUM_CONES][3];
static int pionia = 0;
inline FLOAT RandomVal()   { return ((FLOAT)(rand()-rand()))/RAND_MAX; }

D3DMATRIX Wjmat[2], matView;;
D3DMATERIAL7 Wmtrl;
float jx = 0.0f , jy = 0.0f, jz = 100, jjx = 0.0f, jjy =0.0f, jjz = -10.0f;

//-----------------------------------------------------------------------------
// Name: App_InitDeviceObjects()
// Desc: Initialize scene objects. This function is called after all the
//       DirectDraw and Direct3D objects have been initialized. It makes sense
//       to structure code this way, separating the DDraw/D3D initialization
//       code from the app-specific intialization code.
//-----------------------------------------------------------------------------
HRESULT App_InitDeviceObjects( LPDIRECT3DDEVICE7 pd3dDevice )
{
    DWORD i;

    ZeroMemory( &Wmtrl, sizeof(Wmtrl) );
    Wmtrl.diffuse.r = Wmtrl.diffuse.g = Wmtrl.diffuse.b = 1.0f;
    Wmtrl.ambient.r = Wmtrl.ambient.g = Wmtrl.ambient.b = 1.0f;
	Wmtrl.specular.r = Wmtrl.specular.g = Wmtrl.specular.b = 1.0f;
    pd3dDevice->SetMaterial( &Wmtrl );

    
    // Set the transform matrices. Direct3D uses three independant matrices:
    // the world matrix, the view matrix, and the projection matrix. For
    // convienence, we are first setting up an identity matrix.

    D3DMATRIX mat;
    mat._11 = mat._22 = mat._33 = mat._44 = 1.0f;
    mat._12 = mat._13 = mat._14 = mat._41 = 0.0f;
    mat._21 = mat._23 = mat._24 = mat._42 = 0.0f;
    mat._31 = mat._32 = mat._34 = mat._43 = 0.0f;
	//mat._43 = 10;
    
    D3DMATRIX matWorld = mat;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );

    matView = mat;

	Wjmat[0] = mat;

	mat._41 = 50.0f;
	mat._42 = 1.0f;
	mat._43 = 100.0f;
	Wjmat[1] = mat;
    //matView._43 = 10.0f;
	SetViewMatrix(matView, D3DVECTOR(0.0f, 0.0f, 100.0f),
						   D3DVECTOR(0.0f, 0.0f, -10.0f),
						   D3DVECTOR(0.0f, 0.0f, 1.0f));

    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );



    D3DMATRIX matProj = mat;
    matProj._11 =  1.0f;
    matProj._22 =  1.0f;
    matProj._34 =  1.0f;
    matProj._43 = -1.0f;
    matProj._44 =  0.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

    // Enable z-buffering.
    pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, TRUE );

    // Set up the light. Note: to be friendly for cards that can do hardware
    // transform-and-lighting (TnL), we should (but we don't) check the caps
    // to see if the device can support directional lights. 
    D3DLIGHT7 light;
    ZeroMemory( &light, sizeof(light) );
   light.dltType       =  D3DLIGHT_DIRECTIONAL;
 //   light.dltType       =D3DLIGHT_PARALLELPOINT;
//	light.dcvSpecular.r = 1.0;        /* Specular color of light */
//	light.dcvSpecular.g = 1.0;
//	light.dcvSpecular.b = 1.0;
    light.dcvAmbient.r = 0.4;
    light.dcvAmbient.g = 0.4;
	light.dcvAmbient.b = 0.4;
    light.dcvDiffuse.r  =  1.0f;
    light.dcvDiffuse.g  =  1.0f;
    light.dcvDiffuse.b  =  1.0f;
    light.dvDirection.x =  0.0f;
    light.dvDirection.y =  -1.0f;
    light.dvDirection.z = -1.0f;

//  light.dvPosition.x = 100.0f;
 //light.dvPosition.y = 100.0f;
 //
   light.dvAttenuation0 = 1.0f;
   light.dvRange = D3DLIGHT_RANGE_MAX;
    pd3dDevice->SetLight( 0, &light );
    pd3dDevice->LightEnable( 0, TRUE );
   //pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, 0xffffffff );
  pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, TRUE ); 
    //pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, 0x0000000f );

       // pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
       // pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,  D3DBLEND_SRCALPHA );
        //pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );


	pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );
 	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    	pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    	pd3dDevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE,   TRUE );
   // 	pd3dDevice->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );
    	pd3dDevice->SetRenderState( D3DRENDERSTATE_NORMALIZENORMALS, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_TEXTUREADDRESS, D3DTADDRESS_CLAMP);

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: SetViewMatrix()
// Desc: Given an eye point, a lookat point, and an up vector, this
//       function builds a 4x4 view matrix.
//-----------------------------------------------------------------------------
HRESULT SetViewMatrix( D3DMATRIX& mat, D3DVECTOR& vFrom, D3DVECTOR& vAt,
                       D3DVECTOR& vWorldUp )
{
    // Get the z basis vector, which points straight ahead. This is the
    // difference from the eyepoint to the lookat point.
    D3DVECTOR vView = vAt - vFrom;

    FLOAT fLength = Magnitude( vView );
    if( fLength < 1e-6f )
        return E_INVALIDARG;

    // Normalize the z basis vector
    vView /= fLength;

    // Get the dot product, and calculate the projection of the z basis
    // vector onto the up vector. The projection is the y basis vector.
    FLOAT fDotProduct = DotProduct( vWorldUp, vView );

    D3DVECTOR vUp = vWorldUp - fDotProduct * vView;

    // If this vector has near-zero length because the input specified a
    // bogus up vector, let's try a default up vector
    if( 1e-6f > ( fLength = Magnitude( vUp ) ) )
    {
        vUp = D3DVECTOR( 0.0f, 1.0f, 0.0f ) - vView.y * vView;

        // If we still have near-zero length, resort to a different axis.
        if( 1e-6f > ( fLength = Magnitude( vUp ) ) )
        {
            vUp = D3DVECTOR( 0.0f, 0.0f, 1.0f ) - vView.z * vView;

            if( 1e-6f > ( fLength = Magnitude( vUp ) ) )
                return E_INVALIDARG;
        }
    }

    // Normalize the y basis vector
    vUp /= fLength;

    // The x basis vector is found simply with the cross product of the y
    // and z basis vectors
    D3DVECTOR vRight = CrossProduct( vUp, vView );
    
    // Start building the matrix. The first three rows contains the basis
    // vectors used to rotate the view to point at the lookat point
    mat._11 = vRight.x;  mat._12 = vUp.x;  mat._13 = vView.x;  mat._14 = 0.0f;
    mat._21 = vRight.y;  mat._22 = vUp.y;  mat._23 = vView.y;  mat._24 = 0.0f;
    mat._31 = vRight.z;  mat._32 = vUp.z;  mat._33 = vView.z;  mat._34 = 0.0f;

    // Do the translation values (rotations are still about the eyepoint)
    mat._41 = - DotProduct( vFrom, vRight );
    mat._42 = - DotProduct( vFrom, vUp );
    mat._43 = - DotProduct( vFrom, vView );
    mat._44 = 1.0f;

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: App_FrameMove()
// Desc: Called once per frame, the call is used for animating the scene. The
//       device is used for changing various render states, and the timekey is
//       used for timing of the dynamics of the scene.
//-----------------------------------------------------------------------------
HRESULT App_FrameMove( LPDIRECT3DDEVICE7 pd3dDevice, float x, int dmode )
{
    // Move the view point around in a circle. The view is most conveniently
    // defined by an eye point, a lookat point, and a vector defining the up
    // direction.
    // Set the transform matrices
	if(dmode == 1)
	{
		if( x == 3 ) jx += 5.0f;
		if( x == 1 ) jx -= 5.0f;
		if( x == 2 ) jy += 5.0f;
		if( x == 4 ) jy -= 5.0f;
		if( x == 5 ) jz += 5.0f;
		if( x == 6 ) jz -= 5.0f;
	}
	SetViewMatrix(matView,  D3DVECTOR(jx, jy, jz),
						   D3DVECTOR(jjx, jjy, jjz),
						   D3DVECTOR(0.0f, 1.0f, 1.0f));


    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );





    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: App_Render()
// Desc: Renders the scene. This tutorial draws a bunch of random-colored
//       cones.
//-----------------------------------------------------------------------------
HRESULT App_Render( LPDIRECT3DDEVICE7 pd3dDevice, Vanesa RenderVanesa, HWND g_hWnd)
{
	FileMaterial *RenderMaterial;   
	FileMesh	 *RenderMesh;
	FileMesh	 *local_count_mesh;
	DWORD		local_m_id, p =0;
	// ________Choose Render Mode________ //
         DWORD dwCullMode  = D3DCULL_CCW; 
        // DWORD dwCullMode  = D3DCULL_NONE;
       // DWORD dwShadeMode = D3DSHADE_FLAT;

//			DWORD dwShadeMode = D3DSHADE_GOURAUD;
	//		DWORD dwShadeMode = D3DSHADE_PHONG;
//		DWORD dwShadeMode = D3DCULL_CCW;
       //  DWORD dwFillMode  = D3DFILL_WIREFRAME; 
      //   DWORD dwFillMode  = D3DFILL_SOLID;
        // --------------------------------- //
         pd3dDevice->SetRenderState( D3DRENDERSTATE_CULLMODE,  dwCullMode );


   // pd3dDevice->SetRenderState( D3DRENDERSTATE_SHADEMODE, dwShadeMode );

//         pd3dDevice->SetRenderState( D3DRENDERSTATE_FILLMODE,  dwFillMode );

    pd3dDevice->SetMaterial( &Wmtrl );
	// Clear the viewport and z-buffer
    pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
                       0x000000ff, 1.0f, 0L );

	RenderMaterial = RenderVanesa.MeyMat;
	RenderMesh	   = RenderVanesa.MeyMesh;
    // Begin the scene
    if( FAILED( pd3dDevice->BeginScene() ) )
        return E_FAIL;


for(int j = 0; j < 2; j++)
{
local_count_mesh = RenderMesh;
pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &Wjmat[j] );
		while(local_count_mesh)
		{
		//p++;
		//if(p == 5) break;
		if(local_count_mesh->Texture_Flags == 1) 
		{
			local_m_id = local_count_mesh->Material_ID;
		    pd3dDevice->SetMaterial( &Wmtrl );        
			pd3dDevice->SetTexture(0, (RenderMaterial + local_m_id )->lpD3DSurface);
		} 
		else
		{       
       		local_m_id = local_count_mesh->Material_ID;
			 pd3dDevice->SetTexture(0, (RenderMaterial + local_m_id )->lpD3DSurface);   
		//	(RenderMaterial + local_m_id)->Material = Wmtrl;
			pd3dDevice->SetMaterial( &(RenderMaterial + local_m_id)->Material );        
		}
		//pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &local_count_mesh->Matrix_j );


        pd3dDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 
					  D3DFVF_VERTEX, 
                      local_count_mesh->Cube, 
					  local_count_mesh->numverts,
				  	  local_count_mesh->Index, 
					  local_count_mesh->numfaces * 3, 
					  NULL );
		local_count_mesh = local_count_mesh->Next;
    }

}

    // End the scene.

    pd3dDevice->EndScene();
    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: App_DeleteDeviceObjects()
// Desc: Called when the device is being deleted, this function deletes any
//       device dependant objects.
//-----------------------------------------------------------------------------
VOID App_DeleteDeviceObjects( LPDIRECT3DDEVICE7 pd3dDevice )
{
}




