// MeshView.cpp : implementation file
//
   
#include "stdafx.h"
#include "skin.h"
#include "MeshView.h"
#include "meshdoc.h"


#include "textout.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "skspace.h" // skin animation
#include "mathobj.h"
#define GET_DOC ((CMeshDoc*)GetDocument())
typedef CVec<float> VECTOR;

void DrawSolidBox(VECTOR Min, VECTOR Max);
/////////////////////////////////////////////////////////////////////////////
// CMeshView

HWND GV_hActiveView=NULL;
HWND GV_hActiveViewOld=NULL;

////////////////////////////////////
CSkObj m_Obj; // skin objects
CMeshViews CMeshView::m_Views;


IMPLEMENT_DYNCREATE(CMeshView, CGLView)

CMeshView::CMeshView()
{	
	m_Views.push_back(this);

	m_bEnableLight=true;

	m_bIsActive=false;
	m_bDrawNet=true;

	m_bViewBones=true; // view bones
	m_bViewMesh=true;

	
	// speucalr light
	m_bSpecular=true;

	m_bPers=false; // isometric
}

CMeshView::~CMeshView()
{
}


BEGIN_MESSAGE_MAP(CMeshView, CGLView)
	//{{AFX_MSG_MAP(CMeshView)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_UPDATE_ACTIVEVIEW, OnUpdateActiveview)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_UPDATE_BOUNDINGBOX, OnUpdateBoundingbox)
	ON_WM_MOUSEMOVE()
	ON_COMMAND(ID_ENABLE_LIGHT, OnEnableLight)
	ON_UPDATE_COMMAND_UI(ID_ENABLE_LIGHT, OnUpdateEnableLight)
	//}}AFX_MSG_MAP
	
	ON_COMMAND(ID_VIEW_EXTENTS, OnViewExtents) //this functions are of its parent
	ON_COMMAND(ID_VIEW_PAN, OnViewPan) //we can directly link it without overhead
	ON_COMMAND(ID_VIEW_ROTATE, OnViewRotate)
	ON_COMMAND(ID_VIEW_ZOOM, OnViewZoom)
	ON_COMMAND(ID_VIEW_PERS, OnViewPers)
	ON_COMMAND(ID_VIEW_X, OnViewX)
	ON_COMMAND(ID_VIEW_Y, OnViewY)
	ON_COMMAND(ID_VIEW_Z, OnViewZ)
	ON_COMMAND(ID_VIEW_SECTIONZOOM, OnViewSectionzoom)
	ON_COMMAND(ID_VIEW_PERS, OnViewPers)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PERS, OnUpdateViewPers) //directly linking to parent
	ON_UPDATE_COMMAND_UI(ID_VIEW_ZOOM, OnUpdateViewZoom)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ROTATE, OnUpdateViewRotate)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PAN, OnUpdateViewPan)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SECTIONZOOM, OnUpdateViewSectionzoom)

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeshView drawing

void CMeshView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
	DrawScene();
		if (!m_bPicking) Draw2D(); //show 2d only if it's normal display mode

}

/////////////////////////////////////////////////////////////////////////////
// CMeshView diagnostics

#ifdef _DEBUG
void CMeshView::AssertValid() const
{
	CGLView::AssertValid();
}

void CMeshView::Dump(CDumpContext& dc) const
{
	CGLView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMeshView message handlers
int GV_nFrame=0;  //frame number

void TestCode(void);

void CMeshView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting


	
	// TODO: Add your message handler code here
	//make current rendering context valid
	//wglMakeCurrent(m_hDC, m_hRC);
	m_hDC=GetDC()->GetSafeHdc();
	wglMakeCurrent(GetDC()->GetSafeHdc(), m_hRC);

	//make viewport updated
	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,m_nViewX,m_nViewY);
	glDrawBuffer(GL_BACK);

	OnDraw(&dc);

	// swap buffers
	if (SwapBuffers(m_hDC)==FALSE) TRACE("cannot swap buffers");

	
}

void CMeshView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CGLView::OnLButtonDown(nFlags, point);



	// show boundary
	
	// update handle variables
	GV_hActiveViewOld= GV_hActiveView;

	// turn on new
	m_bIsActive=true;
	GV_hActiveView=GetSafeHwnd();
	InvalidateRect(NULL);


	// turn off old
	CMeshView* old=  (CMeshView*) CMeshView::FromHandle(GV_hActiveViewOld);
	// only if it's different
	if (old && GV_hActiveView!=GV_hActiveViewOld) {
		old->m_bIsActive=false;
		old->InvalidateRect(NULL);
	}


	
}

void CMeshView::Draw2D()
{
	double Pro[16]; //projection matrix
	double Mod[16]; //modelview matrix 
	double m_dvTextColor[3]={0,0,0};

	//backup matrix
	glGetDoublev(GL_PROJECTION_MATRIX, Pro); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, Mod); //get modelview matrix

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, m_dViewX, m_dViewY,0, -1000, 1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	//glprintf(0,24, "Z-Stamp");

	// save to 2d buffer
	glGetDoublev(GL_PROJECTION_MATRIX, m_dvPro2); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, m_dvMod2); //get modelview matrix


	if (m_nCursorID==CURSOR_SECTIONZOOM && m_bLeftButton) {
		CRect& box=m_rectZoom;

		//glColor3d(1,1,1);
		glColor4dv(m_dvTextColor);
			      
		glColor3d(1,1,0);
		glEnable(GL_LINE_STIPPLE);
		glLineWidth(1);
		glLineStipple (1, 0xaaaa);  /*  dotted  */
		glBegin(GL_LINE_LOOP);
		glVertex3d(box.left, box.top, 0);
		glVertex3d(box.left, box.bottom, 0);
		glVertex3d(box.right, box.bottom, 0);
		glVertex3d(box.right, box.top, 0);
		glEnd();
		glDisable(GL_LINE_STIPPLE);
	}

	if (m_bIsActive) {
		glLineWidth(2);
		glColor3d(1,0.5, 0);
		glBegin(GL_LINE_LOOP);
		glVertex3d(0,0,0);
		glVertex3d(m_dViewX-1,0,0);
		glVertex3d(m_dViewX-1,m_dViewY-1,0);
		glVertex3d(0,m_dViewY-1,0);

		glEnd();

	}





	//END
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	//RESTORE MATRIX
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixd(Pro);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd(Mod);


	glEnable(GL_LIGHTING);
}


void DrawSolidBox(VECTOR Min, VECTOR Max)
{
	VECTOR v0(Min.x , Min.y , Max.z );
	VECTOR v1(Min.x , Max.y , Max.z );
	VECTOR v2(Max.x , Max.y , Max.z );
	VECTOR v3(Max.x , Min.y , Max.z );

	VECTOR v4(Min.x , Min.y , Min.z );
	VECTOR v5(Min.x , Max.y , Min.z );
	VECTOR v6(Max.x , Max.y , Min.z );
	VECTOR v7(Max.x , Min.y , Min.z );

	//top & bottom
	VECTOR n;
	glBegin(GL_QUADS);
	n=(v3-v0)*(v2-v3);
	n.Normal();
	v0.Put();
	v3.Put();
	v2.Put();
	v1.Put();

	n=(v5-v4)*(v6-v5);
	n.Normal();
	v4.Put();
	v5.Put();
	v6.Put();
	v7.Put();

	n=(v1-v0)*(v5-v1);
	n.Normal();
	v0.Put();
	v1.Put();
	v5.Put();
	v4.Put();

	n=(v2-v1)*(v6-v2);
	n.Normal();
	v1.Put();
	v2.Put();
	v6.Put();
	v5.Put();

	n=(v3-v2)*(v7-v3);
	n.Normal();
	v2.Put();
	v3.Put();
	v7.Put();
	v6.Put();

	n=(v0-v3)*(v4-v0);
	n.Normal();
	v3.Put();
	v0.Put();
	v4.Put();
	v7.Put();
	glEnd();
}


//DEL void CMeshView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
//DEL {
//DEL 	// TODO: Add your message handler code here and/or call default
//DEL 	switch(nChar) {
//DEL 		case 'F': AfxMessageBox("Front"); break;
//DEL 		case 'B': AfxMessageBox("Back"); break;
//DEL 		case 'L': AfxMessageBox("Left"); break;
//DEL 		case 'R': AfxMessageBox("Right"); break;
//DEL 
//DEL 	}
//DEL 	
//DEL 	CGLView::OnKeyDown(nChar, nRepCnt, nFlags);
//DEL }

void CMeshView::OnUpdateActiveview() 
{
	InvalidateRect(NULL);	
}





void CMeshView::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	CMenu muTemp, *pContextMenu;
	muTemp.LoadMenu(IDR_SPOTMENU);

	pContextMenu= muTemp.GetSubMenu(0);
	pContextMenu->TrackPopupMenu(TPM_LEFTALIGN,
	 point.x ,  point.y , AfxGetMainWnd());
	
}

// adjust bounding box
void CMeshView::OnUpdateBoundingbox() 
{
	MakeViewBox(10);
	KeepAspectRatio(m_AspectRatio); //keep aspect ratio
	SetViewVolume();
	InvalidateRect(NULL);
}
 
void CMeshView::OnInitialUpdate() 
{
	CGLView::OnInitialUpdate();
	
	// simplifies material setup
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);
	
  	AfxGetMainWnd()->SendMessage(WM_COMMAND, ID_UPDATE_BOUNDINGBOX_ALL);

	
}



GLfloat light0Pos[4] =
  {0.0, 0.0, 1.25, 1.00};

void CMeshView::SetLight()
{
	GLfloat specular[]= {1.0, 1.0, 1.0, 1.0};
	GLfloat ambient[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat diffuse[] = { 1.0, 1.0, 1.0, 1.0 };



	// 0.0: sun light
	// 1.0: position light
    GLfloat position[] = { 0, 0, m_Box,  1.0 };
    
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);

	glLightfv(		GL_LIGHT0,		 GL_SPECULAR,	 specular);
    glLightfv(		GL_LIGHT0,		 GL_AMBIENT,	 ambient);
    glLightfv(		GL_LIGHT0,		 GL_DIFFUSE,	 diffuse);
    glLightfv(		GL_LIGHT0,		 GL_POSITION,	 position);

	// attenuation
	glLightf( GL_LIGHT0, GL_CONSTANT_ATTENUATION , 1.0f);
	glLightf( GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.0f);
	glLightf( GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.0f);
	glLightf( GL_LIGHT0, GL_SPOT_EXPONENT, 0.0f);
	glLightf( GL_LIGHT0, GL_SPOT_CUTOFF, 180.0f); // 180.0f default. uniform


	// light model setup
	GLfloat lmodel_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
    GLfloat local_view[] = { 0.0 };
	GLfloat lmodel_twoside[] ={GL_TRUE};

    glLightModelfv(	GL_LIGHT_MODEL_AMBIENT,			 lmodel_ambient);
    glLightModelf(	GL_LIGHT_MODEL_LOCAL_VIEWER,	 1.0);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,  1.0);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
	glEnable(GL_NORMALIZE);


	

	// light model
	
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 1.0);
	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, 0.0); 

	
	// light model
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	if (m_bEnableLight) {
		glEnable(GL_LIGHTING);
	}
	else {
		glDisable(GL_LIGHTING);
	}


}

void CMeshView::OnMouseMove(UINT nFlags, CPoint point) 
{
	
	CGLView::OnMouseMove(nFlags, point);
}

void DrawNet(double xsize, double zsize, double xstep, double zstep)
{

	//adjust xsize , zsize
	if (xstep<0.0000001 || zstep<0.0000001) return; //avoid too small grid
	int countx= (int)xsize/xstep;
	int countz= (int)zsize/zstep;

	//okay
	xsize= (double)countx * xstep;
	zsize= (double)countz * zstep;


	double x,z;
	for (x=-xsize; x<=xsize; x+=xstep) {
		glBegin(GL_LINES);
		glVertex3d(x, 0, -zsize);
		glVertex3d(x, 0,  zsize);
		glEnd();
		
	}
	for (z=-zsize; z<=zsize; z+=zstep) {
		glBegin(GL_LINES);
		glVertex3d(-xsize,0,z);
		glVertex3d(xsize,0,z);
		glEnd();
	}


}

void CMeshView::DrawScene()
{
	//initialize name stack
	glClearColor(1, 1, 1,0);
	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT | 
    GL_STENCIL_BUFFER_BIT);



	glPushMatrix();
	SetLight(); //fixed light
	glDisable(GL_CULL_FACE);
	m_Rot.Set(); //quaternion rotation

	// draw objects

	glDisable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL);
	glColor4ub(255,0,0,128);
	//DrawSolidBox(VECTOR(-2,-1,-3), VECTOR(2,1,4));
	glPointSize(2);
	m_Obj.Show();
	glEnable(GL_LIGHTING);

	// draw grid lines
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glPushMatrix();
	glTranslated(0,0,-5);
	glRotated(90, 1, 0, 0);
	glColor4d(0,0,0,0.5);
	glLineWidth(1);
	glLineStipple(1,0x5555);
	glEnable(GL_LINE_STIPPLE);
	::DrawNet(10, 10, 1, 1);
	glDisable(GL_LINE_STIPPLE);
	glPopMatrix();



	// draw axis
	glEnable(GL_COLOR_MATERIAL);
//	DrawAxis2(5);
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);


	
	
	glPopMatrix();
	
}

void CMeshView::OnEnableLight() 
{
		m_bEnableLight = !m_bEnableLight;

		InvalidateRect(NULL);
}

void CMeshView::OnUpdateEnableLight(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(m_bEnableLight);	
}




void CMeshViews::Paint(void)
{
	iterator i;
	for (i=begin();i!=end();i++) {
		(*i)->InvalidateRect(NULL);
	}
}