// SkSpace.cpp: implementation of the CSkSpace class.
//
//////////////////////////////////////////////////////////////////////
 
#include "stdafx.h"
#include "skin.h"
#include "SkSpace.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CSkSpace::CSkSpace()
{

}

CSkSpace::~CSkSpace()
{

}

void CSkPoints::Show()
{
	iterator i;
	glBegin(GL_POINTS);
	for (i=begin(); i!=end(); i++) {
		i->gv.Put();
	}
	glEnd();
}

void CSkObj::MakeSample()
{
	
	int si=m_Bones.size();
	m_Bones.push_back(CSkBone(VECTOR(0,0,-5),VECTOR(0,1,0),0));
	si=m_Bones.size();
	CSkBone* a= & m_Bones.back();
	m_Bones.m_pRoot= a; 

	m_Bones.push_back(CSkBone(VECTOR(0,0,3),VECTOR(0,1,0),RAD(0)));
	CSkBone* b= & m_Bones.back();

	m_Bones.push_back(CSkBone(VECTOR(0,0,3),VECTOR(0,1,0),RAD(0)));
	CSkBone* c= & m_Bones.back();

	m_Bones.push_back(CSkBone(VECTOR(0,0,3),VECTOR(0,1,0),RAD(0)));
	CSkBone* d= & m_Bones.back();

	// connect
	a->AddChild(b);
	b->AddChild(c);
	c->AddChild(d);

	// make point and connect
	// make points..
	double z;
	double f;
	double r=5;
	double deg=0;
	VECTOR cen(0,0,0); // center point
	VECTOR p;
	double ra,rb,rc,rd;

	double sz=-5, ez=8;
	for (z=sz;z<=ez;z+=0.4) {

		

		r= (1-(z-sz)/(ez-sz))*2.0;
 
		for (deg=0;deg<360;deg+=10) {
			p.x= cos(RAD(deg))*r + cen.x;
			p.y= sin(RAD(deg))*r + cen.y;
			p.z= z + cen.z;
 
			m_Points.push_back(CSkPoint(p.x, p.y, p.z));

			CSkFactors& r=m_Points.back().rates;

			if (z<0) { // -5 -> 0
				f=(z+5)/5.0; 
				ra=1-f;
				rb=f;
				rc=0;
				rd=0;
			}
			else if (z<2) { // 0 -> 2
				f=z/2.0;
				ra=0;
				rb=1-f;
				rc=f;
				rd=0;
			}
			else if (z<5) { // 2->5
				f=(z-2)/3.0;
				ra=0;
				rb=0;
				rc=1-f;
				rd=f;
			}
			else {   // 5 -> 8
				f=(z-5)/3.0;
				ra=0;
				rb=0;
				rc=0;
				rd=1;
			}

			r.push_back(CSkFactor(a,ra));
			r.push_back(CSkFactor(b,rb));
			r.push_back(CSkFactor(c,rc));
			r.push_back(CSkFactor(d,rd));
		}  
	}   



	// calculate glorbal matrix
	m_Bones.Process(m_Bones.m_pRoot);

	// save old global matrix
	// vertices are binded at this point!
	m_Bones.Bind();

}

void CSkObj::Show()
{
	try {
		m_Points.Show();
		m_Bones.Show();
	}
	catch(char* error) {
		AfxMessageBox(error);
		PostQuitMessage(-1);
	}
}

void CSkBone::Show()
{
	glPushMatrix();
	m_GRot.Set();
	DrawAxis(2);
	glPopMatrix();
}

void CSkBone::DrawAxis(double height)
{
	double height2= height*0.5;
	double base=height2*0.1;
	
	//begin
	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	glColor4d(1,1,0,0.2);
	glutSolidCube(base*2);

	//draw Z
	glColor4d(0,0,1,0.2);
	glPushMatrix();
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw Y
	glColor4d(0,1,0,0.2);
	glPushMatrix();
	glRotated(90, -1, 0, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw X
	glColor4d(1,0,0,0.2);
	glPushMatrix();
	glRotated(90, 0, 1, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();


	gluDeleteQuadric(obj);
	//end


}

void CSkObj::Move()
{
	static CSkBones::iterator which=NULL;
	static int mode=0;

	if (GetAsyncKeyState('1')) which= m_Bones[0];
	if (GetAsyncKeyState('2')) which= m_Bones[1];
	if (GetAsyncKeyState('3')) which= m_Bones[2];
	if (GetAsyncKeyState('4')) which= m_Bones[3];

	if (GetAsyncKeyState('R')) mode=0;
	if (GetAsyncKeyState('T')) mode=1;

	if (which==NULL) which=m_Bones[1];

	if (mode==0) { // rotation
		if (GetAsyncKeyState(VK_UP)) which->m_Rot = which->m_Rot *	ROT(VECTOR(1,0,0),RAD(10))	;
		if (GetAsyncKeyState(VK_DOWN)) which->m_Rot = which->m_Rot *	ROT(VECTOR(1,0,0),RAD(-10))	;
		if (GetAsyncKeyState(VK_LEFT)) which->m_Rot = which->m_Rot *	ROT(VECTOR(0,1,0),RAD(10))	;
		if (GetAsyncKeyState(VK_RIGHT)) which->m_Rot = which->m_Rot *	ROT(VECTOR(0,1,0),RAD(-10))	;
	}

	if (mode==1) { // translation
		if (GetAsyncKeyState(VK_UP)) which->m_Rot = which->m_Rot *	ROT(VECTOR(0,1,0))	;
		if (GetAsyncKeyState(VK_DOWN)) which->m_Rot = which->m_Rot *	ROT(VECTOR(0,-1,0))	;
		if (GetAsyncKeyState(VK_LEFT)) which->m_Rot = which->m_Rot *	ROT(VECTOR(-1,0,0))	;
		if (GetAsyncKeyState(VK_RIGHT)) which->m_Rot = which->m_Rot *	ROT(VECTOR(1,0,0))	;
	}




	// prepare matrix
	m_Bones.Process(m_Bones.m_pRoot);

	// Calculate Difference
	m_Bones.CalcGRotTmp();
	m_Points.Animate();
	

}

void CSkPoints::Move(ROT r)
{
	iterator i;
	for (i=begin(); i!=end(); i++) {
		i-> v = r *   i->v;

	} // end of for
}

void CSkBones::Show()
{
	iterator bi;
	for (bi=begin(); bi!=end(); bi++) 
	{
		bi->Show();
	} // end of for
}

// local matrix is computed at this time
// compute ..
void  CSkBones::Process(CSkBone* pBone)
{
	if (pBone==NULL) return;
	
	CSkBone* child=pBone->m_pChild;
	CSkBone* sibling=pBone->m_pSibling;
	CSkBone* parent=pBone->m_pParent;

	if (parent) {
		pBone->m_GRot= parent->m_GRot * pBone->m_Rot;
	}
	else 
		pBone->m_GRot= pBone->m_Rot;


	if (sibling!=pBone) Process(sibling);
	if (child!=pBone) Process(child);
}



void CSkBones::Bind()
{
	iterator i;
	for (i=begin(); i!=end(); i++) 
		i->m_GRotOld=i->m_GRot;
}
  
void CSkBones::CalcGRotTmp()
{
	iterator i;
	for (i=begin(); i!=end(); i++) 
	i->m_GRotTmp= i->m_GRot* ~ i->m_GRotOld;
}

void CSkPoints::Animate()
{
	iterator i;
	for (i=begin();i!=end();i++) {
		i->Animate();
	}
}    
  
void CSkPoint::Animate()
{
	CSkFactors::iterator fi;

	VECTOR tv;
	for (fi=rates.begin(); fi!=rates.end(); fi++) {
		tv +=  (fi->m_pBone->m_GRotTmp*v) * fi->m_dRate  ;
	}

	gv=tv;
}
