// SkSpace.h: interface for the CSkSpace class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SKSPACE_H__53733475_644A_11D4_A9D1_0000E8388D55__INCLUDED_)
#define AFX_SKSPACE_H__53733475_644A_11D4_A9D1_0000E8388D55__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "mathobj.h"
typedef CVec<float> VECTOR;
typedef CRot<float> ROT; // rotation then translation

// stl
#include <vector>
#include <list>
using namespace std;

////////////////////////////////////////////////////////
// connecting point and its contribution
class CSkBone;
class CSkPoint;

class CSkFactor{
public:
	CSkBone* m_pBone;
	double m_dRate;
	CSkFactor(void) {
		m_pBone=NULL;
		m_dRate=0;
	}
	CSkFactor(CSkBone* pBone,double dRate)
	{
		m_pBone=pBone;
		m_dRate=dRate;
	}

};
class CSkFactors :
public list<CSkFactor> {
public:

};

// vertex
class CSkPoint
{
	public:
	void Animate(void);
	VECTOR v; // orinal point
	VECTOR gv;  // animated from v

		CSkPoint(float X, float Y, float Z)
		{
			gv=v=VECTOR(X,Y,Z);
		}

	CSkFactors rates;
};

class CSkPoints
: public vector<CSkPoint>
{

public:
	void Animate(void);
	void Move(ROT r);
	void Show(void);
};

//////////////////////////////////////////////////////
// bone
class CSkBone
{
public:

	ROT m_Rot; // local matrix 

	ROT m_GRot; // global matrix
	
	ROT m_GRotOld; // old global matrix
	ROT m_GRotTmp; // difference


	// tree structure
	CSkBone* m_pSibling;
	CSkBone* m_pChild;
	CSkBone* m_pParent;
	void AddChild(CSkBone* pBone)
	{
		if (pBone==NULL) throw "null bone";

		pBone->m_pParent=this;

		if (m_pChild==NULL) m_pChild=pBone;
		else m_pChild->AddSibling(pBone);
	}
	void AddSibling(CSkBone* pBone)
	{
		if (pBone==NULL) throw "null bone";

		pBone->m_pParent=m_pParent;

		if (m_pSibling==NULL) m_pSibling=pBone;
		else m_pSibling->AddSibling(pBone);
	}

	void DrawAxis(double);
	void Show(void);

	CSkBone(void) 
	{
		m_pSibling=NULL;
		m_pChild=NULL;
		m_pParent=NULL;
	}

	CSkBone(VECTOR P, VECTOR N, float Th)
	{
		m_Rot=ROT(P,N,Th);
		m_pSibling=NULL;
		m_pChild=NULL;
		m_pParent=NULL;
	}
};
class CSkBones
: public list<CSkBone>
{
public:
	void CalcGRotTmp(void);
	void Bind(void);
	void Process(CSkBone*);
	CSkBone* m_pRoot;

	void Show(void);
	iterator operator[] (int i) 
	{
		if (i<0 || i>=size()) throw "CSkBones: null pointer";
		iterator oi=begin();
		advance(oi,i);
		return oi;
	}
	CSkBones(void) {
		m_pRoot=NULL;
	}
};


class CSkObj // skin object
{
public:
	void Move(void);
	void Show(void);
	void MakeSample(void);
	CSkPoints m_Points; // point cloud

	CSkBones m_Bones; // bones, for data storage and management
	CSkObj(void) {
	}
};


///////////////////////////////////////////////////////
class CSkSpace  
{
public:
	CSkSpace();
	virtual ~CSkSpace();

};

#endif // !defined(AFX_SKSPACE_H__53733475_644A_11D4_A9D1_0000E8388D55__INCLUDED_)
