#include "stdafx.h"
#include "meshspace.h"
#include "mathobj.h"
typedef CVec<double> VECTOR;

void DrawRing(CColorMap& map)
{
		glEnable(GL_CULL_FACE);
	double or=10; // outer radius
	double ir=8; // inner radius
	double depth=2; // depth
	double dstep=5; //degree step
	int num=10; // number of colors


	double d=0; // degrees
	double d2; // second degrees
	
	double ds=360/num;
	double dn; // next degree
	VECTOR op,ip,np,op2,ip2,np2;
	double r,g,b;

	// top
	glNormal3d(0,0,1);

	for (d=0;d<=360;d+=dstep) {
		// set color
		d2= ((int)(d/ds))*ds;
		map.GetColor3(d2,360, r,g,b);
		glColor3d(r,g,b);


		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=0;
		
		// inner
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=0;

		dn=d+dstep;
		if (dn>=360.0) dn=360.0;
		// outer 
		op2.x= cos(RAD(dn))*or;
		op2.y= sin(RAD(dn))*or;
		op2.z=0;
		
		// inner
		ip2.x= cos(RAD(dn))*ir;
		ip2.y= sin(RAD(dn))*ir;
		ip2.z=0;

		// draw
		glBegin(GL_QUADS);
		ip.Put();
		op.Put();
		op2.Put();
		ip2.Put();
		glEnd();

	

	}


	// bottom
	glNormal3d(0,0,-1);
	for (d=0;d<=360;d+=dstep) {
				// set color
		d2= ((int)(d/ds))*ds;
		map.GetColor3(d2,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=-depth;
		
		// inner
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=-depth;

		dn=d+dstep;
		if (dn>=360.0) dn=360.0;
		// outer 
		op2.x= cos(RAD(dn))*or;
		op2.y= sin(RAD(dn))*or;
		op2.z=-depth;
		
		// inner
		ip2.x= cos(RAD(dn))*ir;
		ip2.y= sin(RAD(dn))*ir;
		ip2.z=-depth;

		// draw
		glBegin(GL_QUADS);
		ip2.Put();
		op2.Put();
		op.Put();
		ip.Put();
		glEnd();

	}


	// outer wall
	for (d=0;d<=360;d+=dstep) {
			// set color
		d2= ((int)(d/ds))*ds;
		map.GetColor3(d2,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=0;
		
		// outer
		ip.x= cos(RAD(d))*or;
		ip.y= sin(RAD(d))*or;
		ip.z=-depth;

		dn=d+dstep;
		if (dn>=360.0) dn=360.0;

		op2.x= cos(RAD(dn))*or;
		op2.y= sin(RAD(dn))*or;
		op2.z=0;
		
		ip2.x= cos(RAD(dn))*or;
		ip2.y= sin(RAD(dn))*or;
		ip2.z=-depth;


		// next 
		np.x= cos(RAD(d+dstep))*or;
		np.y= sin(RAD(d+dstep))*or;
		np.z=0;

		// next 
		np2.x= cos(RAD(dn+dstep))*or;
		np2.y= sin(RAD(dn+dstep))*or;
		np2.z=0;

		// compute normal
		VECTOR n=(ip-op)*(np-op);
		VECTOR n2=-(op2-ip2)*(np2-ip2);


		// draw
		glBegin(GL_QUADS);
		n.Normal();
		op.Put();
		ip.Put();
		n2.Normal();
		ip2.Put();
		op2.Put();
		glEnd();

	}


		// inner wall
	for (d=0;d<=360;d+=dstep) {
			// set color
		d2= ((int)(d/ds))*ds;
		map.GetColor3(d2,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*ir;
		op.y= sin(RAD(d))*ir;
		op.z=0;
		
		// outer
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=-depth;

		dn=d+dstep;
		if (dn>=360.0) dn=360.0;

		op2.x= cos(RAD(dn))*ir;
		op2.y= sin(RAD(dn))*ir;
		op2.z=0;
		
		ip2.x= cos(RAD(dn))*ir;
		ip2.y= sin(RAD(dn))*ir;
		ip2.z=-depth;


		// next 
		np.x= cos(RAD(d+dstep))*ir;
		np.y= sin(RAD(d+dstep))*ir;
		np.z=0;

		// next 
		np2.x= cos(RAD(dn+dstep))*ir;
		np2.y= sin(RAD(dn+dstep))*ir;
		np2.z=0;

		// compute normal
		VECTOR n=-(ip-op)*(np-op);
		VECTOR n2=(op2-ip2)*(np2-ip2);


		// draw
		glBegin(GL_QUADS);
		n2.Normal();
		op2.Put();
		ip2.Put();
		n.Normal();
		ip.Put();
		op.Put();
		glEnd();

	}



}
void DrawSmooRing(CColorMap& map)
{
	glEnable(GL_CULL_FACE);





	double or=10; // outer radius
	double ir=8; // inner radius
	double depth=2; // depth
	double dstep=5; //degree step
	int num=8; // number of colors


	double d=0; // degrees

	
	double ds=360/num;
	VECTOR op,ip,np,op2,ip2;
	double r,g,b;

	// top
	glNormal3d(0,0,1);

	glBegin(GL_TRIANGLE_STRIP);
	for (d=0;d<=360;d+=dstep) {
		// set color
		map.GetColor3(d,360, r,g,b);
		glColor3d(r,g,b);


		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=0;
		
		// inner
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=0;

		// draw
		ip.Put();
		op.Put();

	}
	glEnd();


	// bottom
	glNormal3d(0,0,-1);
	glBegin(GL_TRIANGLE_STRIP);
	for (d=0;d<=360;d+=dstep) {
		map.GetColor3(d,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=-depth;
		
		// inner
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=-depth;

		// draw
		op.Put();
		ip.Put();

	}
	glEnd();


	// outer wall
	glNormal3d(0,0,-1);
	glBegin(GL_TRIANGLE_STRIP);
	for (d=0;d<=360;d+=dstep) {
		map.GetColor3(d,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=0;
		
		// outer
		ip.x= cos(RAD(d))*or;
		ip.y= sin(RAD(d))*or;
		ip.z=-depth;

		// next 
		np.x= cos(RAD(d+dstep))*or;
		np.y= sin(RAD(d+dstep))*or;
		np.z=0;

		// compute normal
		VECTOR n=(ip-op)*(np-op);
		n.Normal();

		// draw
		op.Put();
		ip.Put();

	}
	glEnd();


	// inner wall
	glNormal3d(0,0,-1);
	glBegin(GL_TRIANGLE_STRIP);
	for (d=0;d<=360;d+=dstep) {
		map.GetColor3(d,360, r,g,b);
		glColor3d(r,g,b);



		// outer 
		op.x= cos(RAD(d))*ir;
		op.y= sin(RAD(d))*ir;
		op.z=0;
		
		// outer
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=-depth;

		// next 
		np.x= cos(RAD(d+dstep))*ir;
		np.y= sin(RAD(d+dstep))*ir;
		np.z=0;

		// compute normal
		VECTOR n=-(ip-op)*(np-op);
		n.Normal();

		// draw
		ip.Put();
		op.Put();

	}
	glEnd();


}

// draw rainbow rings and one pingpong ball
void TestCode2(void)
{
		CColorMap map;
	map.AddColor(CColor(0.5,0,0));
	map.AddColor(CColor(1,0,0));
	map.AddColor(CColor(1,0.5,0));

	map.AddColor(CColor(1,1,0));
	map.AddColor(CColor(0.5,1,0));

	map.AddColor(CColor(0,0.5,0));
	map.AddColor(CColor(0,1,0));
	map.AddColor(CColor(0,1,0.5));
	
	map.AddColor(CColor(0,1,1));
	map.AddColor(CColor(0,0.5,1));

	map.AddColor(CColor(0,0,1));
	map.AddColor(CColor(0,0,0.5));
	map.AddColor(CColor(0.5,0,1));

	map.AddColor(CColor(1,0,1));
	map.AddColor(CColor(1,0,0.5));

	glPushMatrix();
	DrawRing(map);
	glPopMatrix();
	glPushMatrix();
	glTranslated(0,0,-5);
	DrawSmooRing(map);
	glPopMatrix();

	glColor3d(1,1,1);
	glutSolidSphere(5, 20, 20);
}

class CColorNode{
public:
	double m_dR, m_dG, m_dB;
	CColorNode(double R, double G, double B) {
		m_dR=R, m_dG= G, m_dB=B;
	}

	void Set(void)
	{
		glColor3d(m_dR, m_dG, m_dB);
	}
	CColorNode operator + (CColorNode& tmp)
	{
		return CColorNode(m_dR+ tmp.m_dR,
						m_dG+ tmp.m_dG,
						m_dB + tmp.m_dB);
	}

	CColorNode operator - (CColorNode& tmp)
	{
		return CColorNode(m_dR- tmp.m_dR,
						m_dG- tmp.m_dG,
						m_dB - tmp.m_dB);
	}

	CColorNode operator * (double tmp)
	{
		return CColorNode(m_dR*tmp,
			m_dG* tmp,
			m_dB* tmp);
	}
	CColorNode operator / (double tmp)
	{
		return CColorNode(m_dR/tmp,
			m_dG/ tmp,
			m_dB/ tmp);
	}
};
class CColorNodes:
public vector<CColorNode>
{
public:
	CColorNode GetColor(double dMin, double dMax, double dObj);
	
	double m_dMin, m_dMax;
	double m_dStep;
	double m_dRange;
};

CColorNode CColorNodes::GetColor(double dMin,double dMax, double dObj)
{
	ASSERT(!empty());

	//update data
	m_dMin=dMin;m_dMax=dMax;
	m_dRange= (m_dMax- m_dMin);
	m_dStep= m_dRange / size();

	//get position
	if (dObj>120) {
		int a=0;
		a+=5;
	}
	int down= (dObj-dMin)/m_dStep; // index
	int up= down+1;
	
	double downv= down*m_dStep+dMin; //value
	double upv= up*m_dStep+dMin;

	// valid?
	if (down<0) down+=size();
	if (down>=size()) down %= size();
	if (up<0) up+=size();
	if (up>=size()) up %= size();

	

	// get color
	CColorNode& downc= at(down);
	CColorNode& upc= at(up);


	// interploate
	CColorNode tmp= (upc-downc)*(dObj-downv)/m_dStep + downc;

	return tmp;
}

void TestCode3(void)
{
	CColorNodes map;
	map.push_back(CColorNode(1,0,0));
	map.push_back(CColorNode(1,1,0));
	map.push_back(CColorNode(0,1,0));
	map.push_back(CColorNode(0,1,1));
	map.push_back(CColorNode(0,0,1));
	map.push_back(CColorNode(1,0,1));


	double or=10; // outer radius
	double ir=8; // inner radius
	double depth=2; // depth
	double dstep=5; //degree step
	int num=8; // number of colors
	double d=0; // degrees

	double ds=360/num;
	VECTOR op,ip,np,op2,ip2;

	// top
	glEnable(GL_COLOR_MATERIAL);

	glBegin(GL_TRIANGLE_STRIP);
	for (d=0;d<=360;d+=dstep) {
		// set color
		map.GetColor(0,360,d).Set();


		// outer 
		op.x= cos(RAD(d))*or;
		op.y= sin(RAD(d))*or;
		op.z=0;
		
		// inner
		ip.x= cos(RAD(d))*ir;
		ip.y= sin(RAD(d))*ir;
		ip.z=0;

		// draw
		ip.Put();
		op.Put();

	}
	glEnd();


}

// one time initializer
GLuint texture[100];
int tex_on=false;

AUX_RGBImageRec *LoadBmp(char* FileName)
{
	FILE* File=NULL;
	if (FileName==NULL) return NULL;
	File= fopen(FileName, "rb");
	if (File) { // open!
		fclose(File);
		return auxDIBImageLoad(FileName);
	}

	// cannot open, exit!
	return NULL;
}
int LoadTexture(void)
{
	int status=false;
	AUX_RGBImageRec* image=NULL;

	image=LoadBmp("nehe.bmp");
	if (image==NULL) return false; // fail.

	glGenTextures(1, & texture[0]);
	glBindTexture(GL_TEXTURE_2D, texture[0]);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, image->sizeX, image->sizeY, 
		0, GL_RGB, GL_UNSIGNED_BYTE,	image->data);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		
	// now texture data is built!

	// free memory now
/*	if (image) {
		if (image->data) free(image->data);
		free(image);
	}*/

	
	// finish
	tex_on=true;
	return true;

}
void TestStart(void)
{
	if (LoadTexture()) AfxMessageBox("Texture load okay");
	else AfxMessageBox("Texture error");
		glEnable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE);	
}


void TestCode(void)
{

	if (tex_on) {
	glBindTexture(GL_TEXTURE_2D, texture[0]);



	glBegin(GL_QUADS);
	glPushMatrix();
	glColor3d(1,0,0);
	// Front Face
	glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f, -1.0f,  1.0f);
	glTexCoord2f(1.0f, 0.0f); glVertex3f( 1.0f, -1.0f,  1.0f);
	glTexCoord2f(1.0f, 1.0f); glVertex3f( 1.0f,  1.0f,  1.0f);
	glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,  1.0f,  1.0f);
	glPopMatrix();
	glEnd();
	}
}