// ColorCircle.cpp : implementation file
//

#include "stdafx.h"
#include "ColorCircle.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorCircle

CColorCircle::CColorCircle()
{
}

CColorCircle::~CColorCircle()
{
}


BEGIN_MESSAGE_MAP(CColorCircle, CGLWnd)
	//{{AFX_MSG_MAP(CColorCircle)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CColorCircle message handlers

// CCW polygon definition
// glFrontFace(GL_CCW); <-default value
void CColorCircle::DrawCircle(double H, double S, double I, double radius)
{
	VECTOR p0,p1,p2,p3;
	p0=p1=p2=p3=VECTOR(0.0,0.0,0.0);
	double r;
	double rs= 1; // radius step;
	double hs= 10; // degree step
  
	double R,G,B;

	double st= S; // saturation level


	glNormal3d(0,1,0);

	// draw bnad
	glDisable(GL_DEPTH_TEST);
	glEnable (GL_BLEND);
  	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


	for (H=0;H<360.0;H+=hs)
	for (r=0;r<radius;r+=rs)
	{

		glBegin(GL_QUADS);
		p0.x= cos(RAD(H))*r;
		p0.y= sin(RAD(H))*r;
		S=p0.Size()/radius;
		HSI2RGB(H,S,I, R,G,B); glColor4d(R,G,B,1);
		p0.Put();

		p1.x= cos(RAD(H))*(r+rs);
		p1.y= sin(RAD(H))*(r+rs);
		S=p1.Size()/radius;
		HSI2RGB(H,S,I, R,G,B); glColor4d(R,G,B,1);
		p1.Put();

		p2.x= cos(RAD(H+hs))*(r+rs);
		p2.y= sin(RAD(H+hs))*(r+rs);
		S=p2.Size()/radius;
		HSI2RGB(H+hs,S,I, R,G,B); glColor4d(R,G,B,1);
		p2.Put();

		p3.x= cos(RAD(H+hs))*(r);
		p3.y= sin(RAD(H+hs))*(r);
		S=p3.Size()/radius;
		HSI2RGB(H+hs,S,I, R,G,B); glColor4d(R,G,B,1);
		p3.Put();
		glEnd();

		glColor4d(0,0,0,0.2);
		glBegin(GL_LINE_LOOP);
		p0.Put();
		p1.Put();
		p2.Put();
		p3.Put();
		glEnd();
	}
	


	
	glLineWidth(2);
	glColor4d(0,0,0,0.5);
	r=st*radius; // current saturation
	glBegin(GL_LINE_LOOP);
	for (H=0;H<360.0;H+=hs)
	{

		p0.x= cos(RAD(H))*r;
		p0.y= sin(RAD(H))*r;
		p0.Put();
	}
	glEnd();
	glLineWidth(1);
	glDisable (GL_BLEND);
	glEnable(GL_DEPTH_TEST);

}
void CColorCircle::RenderScene()
{
	
	// OpenGL animation code goes here

//	glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
	COLORREF color = ::GetSysColor(COLOR_3DFACE);
	glClearColor((float)GetRValue(color)/255.0f,
				 (float)GetGValue(color)/255.0f,
				 (float)GetBValue(color)/255.0f,
				 1.0);

	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT | 
    GL_STENCIL_BUFFER_BIT);
	glShadeModel(GL_SMOOTH);
	glDisable(GL_CULL_FACE);
	glEnable(GL_COLOR_MATERIAL);
	glColor3d(1,0.5,0);
	glPushMatrix();
	DrawCircle(m_dH, m_dS, m_dI, 10.0);
	glPopMatrix();

}
