// ColorConvert.cpp: implementation of the CColorConvert class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ColorConvert.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CColorConvert::CColorConvert()
{

}

CColorConvert::~CColorConvert()
{

}


// 0 < H < 360
// 0 (shade of gray) < S < 1 (pure color)
// 0 (black) < V < 1 (white)  ; intensity
void CColorConvert::RGB2HSI(double R, double G, double B,
			 double& H, double& S, double& V)
{
	double Delta;
	double Min;
	
	Min = MinValue(R,G,B);
	V= MaxValue(R,G,B);
	Delta= V - Min;

	// calculate saturation
	if (V==0.0) S= 0.0; else S= Delta/ V;

	if (S==0.0) H = NAN;
	else {
		if (R==V) H=60.0*(G-B)/Delta;
		else if (G==V) H=120.0 + 60.0*(B-R)/Delta;
		else if (B==V) H= 240.0 + 60.0*(R-G)/Delta;
		if (H<0.0) H += 360.0;
	}

}

void CColorConvert::HSI2RGB(double H, double S, double V,
			 double& R, double& G, double& B)
{
	double f;
	int i;
	double hTemp;
	double p,q,t;

	if (S==0.0) // color is on black and white center line
	{
		if (H==NAN) { // black , grey , white
			R=G=B=V;
		}
		else {
			// H can be any value
			H=NAN;
			R=G=B=V;
		}
	}
	else { // chromatic color
		if (H==360.0) hTemp=0.0;
		else hTemp= H;
  
		hTemp=hTemp/60.0; // h is [0,6)
		i= (int) hTemp; // get integer part
		f= hTemp-i; // get fractional part

		p= V*(1.0-S);
		q= V*(1.0-(S*f));
		t= V*(1.0-(S*(1.0-f)));

		switch(i) {
			case 0: R=V, G=t, B=p; break;
			case 1: R=q, G=V, B=p; break;
			case 2: R=p, G=V, B=t; break;
			case 3: R=p, G=q, B=V; break;
			case 4: R=t, G=p, B=V; break;
			case 5: R=V, G=p, B=q; break;

		}
	}

}



void CColorConvert::DrawBar(CDC& dc, int x1, int y1, int x2, int y2, double H, double S, double I)
{

	double R,G,B;

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	dc.SelectObject(&pen);
	dc.Rectangle(x1,y1, x2, y2);

	COLORREF color;
	double x;
	for (x=0;x<width;x++) {
		H= x/width*360.0;

		HSI2RGB(H,S,I, R, G, B);
		color=RGB(R*255.0, G*255.0, B*255.0);

		CPen pen(PS_SOLID, 1, color);
		dc.SelectObject(&pen);

		dc.MoveTo((int) (x+x1+1), (int) (y1+1));
		dc.LineTo((int)(x+x1+1), (int)(y1+1 + height));
	}
	


}

void CColorConvert::DrawBar2(CDC& dc, int x1, int y1, int x2, int y2, double H, double S, double I)
{

	double R,G,B;

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	dc.SelectObject(&pen);
	dc.Rectangle(x1,y1, x2, y2);
	COLORREF color;

	double x;
	for (x=0;x<width;x++) {
		S= x/width;
		HSI2RGB(H,S,I, R, G, B);

		color=RGB(R*255.0, G*255.0, B*255.0);
		CPen pen(PS_SOLID, 1, color);
		dc.SelectObject(&pen);

		dc.MoveTo((int)(x+ x1+ 1),(int) (y1+1));
		dc.LineTo((int)(x+ x1+ 1), (int)(y1+1 + height));
	}
	


}


void CColorConvert::DrawBar3(CDC& dc, int x1, int y1, int x2, int y2, double H, double S, double I)
{

	double R,G,B;

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	dc.SelectObject(&pen);
	dc.Rectangle(x1,y1, x2, y2);
	COLORREF color;


	double x;
	for (x=0;x<width;x++) {
		I = x/ width;

		HSI2RGB(H,S,I, R, G, B);
		color=RGB(R*255.0, G*255.0, B*255.0);
		CPen pen(PS_SOLID, 1,color );
		dc.SelectObject(&pen);

		dc.MoveTo((int)(x+ x1+1) , (int)(y1+ 1));
		dc.LineTo((int)(x+ x1+1), (int)(y1+ 1 +height));
	}
	


}



void CColorConvert::DrawBar4(CDC& dc, int x1, int y1, int x2, int y2, double R, double G, double B)
{

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	CBrush brush(RGB(R*255.0, G*255.0, B*255.0));

	dc.SelectObject(&pen);
	dc.SelectObject(&brush);
	dc.Rectangle(x1,y1, x2, y2);


}

void CColorConvert::DrawBar5(CDC& dc, int x1, int y1, int x2, int y2, double R, double G, double B)
{

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	CBrush brush(RGB(R*255.0, 0, 0));

	dc.SelectObject(&pen);
	dc.SelectObject(&brush);
	dc.Rectangle(x1,y1, x2, y2);


}



void CColorConvert::DrawBar6(CDC& dc, int x1, int y1, int x2, int y2, double R, double G, double B)
{

	double width=(x2-x1-2);
	double height=(y2-y1-2);





	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	CBrush brush(RGB(0, G*255.0, 0));

	dc.SelectObject(&pen);
	dc.SelectObject(&brush);
	dc.Rectangle(x1,y1, x2, y2);



}


void CColorConvert::DrawBar7(CDC& dc, int x1, int y1, int x2, int y2, double R, double G, double B)
{

	double width=(x2-x1-2);
	double height=(y2-y1-2);



	CPen pen(PS_SOLID, 1, RGB(0,0,0));
	CBrush brush(RGB(0, 0, B*255.0));

	dc.SelectObject(&pen);
	dc.SelectObject(&brush);
	dc.Rectangle(x1,y1, x2, y2);
	


}
