// GLWnd.cpp : implementation file
//

#include "stdafx.h"
#include "GLWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLWnd

CGLWnd::CGLWnd()
{
	
}

CGLWnd::~CGLWnd()
{
}


BEGIN_MESSAGE_MAP(CGLWnd, CWnd)
	//{{AFX_MSG_MAP(CGLWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGLWnd message handlers

//////////////////////////////////////////////////////////////////////////////////////////



int CGLWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	

	// enable OpenGL for the window
	EnableOpenGL( m_hWnd, &m_hDC, &m_hRC );


	//initial setting
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_NORMALIZE);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glEnable(GL_CULL_FACE);


	
	return 0;
}

void CGLWnd::OnDestroy() 
{
	CWnd::OnDestroy();
	
	// shutdown OpenGL
	DisableOpenGL( m_hWnd, m_hDC, m_hRC );	
}

void CGLWnd::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	StartUpdate();

	SetLight();
	RenderScene();


	SwapBuffers( m_hDC );

	// this position is very important!
	// call this after swapping buffer!
	EndUpdate();
	// Do not call CWnd::OnPaint() for painting messages
}

void CGLWnd::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);

	StartUpdate();

	m_nWndX=cx;
	m_nWndY=cy;
	KeepAspectRatio(cx,cy);


	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,cx,cy);
	glDrawBuffer(GL_BACK);

	SetViewVolume();
	glGetIntegerv(GL_VIEWPORT, m_nvVP);


	
	EndUpdate();
	
}

BOOL CGLWnd::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	//return CWnd::OnEraseBkgnd(pDC);
	return true;
}


BOOL CGLWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style |= CS_OWNDC; // some video card it causes problems..
	
	return CWnd::PreCreateWindow(cs);
}



void CGLWnd::Make(CWnd *parent, int ID)
{
	CClientDC dc(parent);
	parent->GetDlgItem(ID)->GetWindowRect(m_Rect);
	parent->ScreenToClient(m_Rect);

	if (!Create(NULL, NULL, WS_CHILD | WS_CLIPCHILDREN  | WS_VISIBLE ,
		m_Rect, parent, ID, NULL))
	{
		TRACE0("Failed to create view window\n");
	}

}

