// glprintView.cpp : implementation of the CGLView class
//

#include "stdafx.h"
#include "glview.h"

#include "resource.h"
#include <math.h> //for fabs
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//external data
void Show3DS(int i) ;
void DrawCharX(void);
void DrawCharY(void);
void DrawCharZ(void);



/////////////////////////////////////////////////////////////////////////////
// CGLView

IMPLEMENT_DYNCREATE(CGLView, CView)

BEGIN_MESSAGE_MAP(CGLView, CView)
	//{{AFX_MSG_MAP(CGLView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_SETFOCUS()
	ON_WM_SETCURSOR()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLView construction/destruction

CGLView::CGLView()
{
	//default color
	m_dvBackColor[0]=0.0; //background color
	m_dvBackColor[1]=0.0;
	m_dvBackColor[2]=0.0;
	m_dvBackColor[3]=0.0;

	// text color
	m_dvTextColor[0]=1.0; //text color
	m_dvTextColor[1]=1.0; 
	m_dvTextColor[2]=1.0; 
	m_dvTextColor[3]=1.0; // alpha blending

	m_bIsActive=false; // active view for multiple views

	// mouse button variables
	m_bLeftButton=false;

	// change cursor ?
	m_bChangeCursor=true;

	m_hRC=NULL; //rendering context
	m_hDC=NULL; //device context


	//bounding box
	m_BoundX=10;
	m_BoundY=10;
	m_BoundZ=10;
	m_BoundR=10; //bounding sphere
	m_dGridSize=1; //grid?double GV_dGridSize=1; //grid?
	MakeViewBox(10);


	

	//viewport
	m_nViewX=m_nViewY=0;

	//setup data
	ResetupData();

	// start speed buffer
	InitSpeed(); // initially turned off

}

CGLView::~CGLView()
{
	//write data
	AfxGetApp()->WriteProfileInt("Settings", "Perspective", m_bPers);
}

BOOL CGLView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGLView drawing

//for printer and screen output
void CGLView::OnDraw(CDC* pDC)
{
	// TODO: add draw code for native data here
	DrawScene();
}

/////////////////////////////////////////////////////////////////////////////
// CGLView printing

BOOL CGLView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CGLView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	// TODO: add extra initialization before printing
	LPDEVMODE* pMode = (LPDEVMODE*) pInfo->m_pPD->m_pd.hDevMode;
	DEVMODE* mode = *pMode;
	CString mMsg;
	TCHAR* pChar = (TCHAR*)&mode->dmDeviceName[0];
	
	int nBitsPerPixel = pDC->GetDeviceCaps(BITSPIXEL);
	int nColors		= pDC->GetDeviceCaps(NUMCOLORS);
	int nBitPlanes	= pDC->GetDeviceCaps(PLANES);
	int nColorRes	= pDC->GetDeviceCaps(COLORRES);
	int nRasterCaps	= pDC->GetDeviceCaps(RASTERCAPS);

	// Does the device support raster operations?
	if(nRasterCaps & RC_STRETCHBLT)
		m_bStretchBlt = TRUE;
	if(nRasterCaps & RC_STRETCHDIB)
		m_bStretchDIBits = TRUE;

	TRACE("You selected printer '%s'\n", pChar);
	TRACE("BitsPerPixel = %d\n", nBitsPerPixel);
	TRACE("NumColors	= %d\n", nColors);
	TRACE("NumBitPlanes = %d\n", nBitPlanes);
	TRACE("ColorResolution		= %d\n", nColorRes);	
	TRACE("Supports StretchBlt	= %d\n", m_bStretchBlt);
	TRACE("Supports StretchDIBits = %d\n", m_bStretchDIBits);

	if(!m_bStretchBlt && !m_bStretchDIBits)
	{
		mMsg.Format("Printer '%s' does not support required functions!", pChar);
		AfxMessageBox(mMsg, MB_OK);
	}
}

void CGLView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
	TRACE("end printing \n");
}

/////////////////////////////////////////////////////////////////////////////
// CGLView diagnostics

#ifdef _DEBUG
void CGLView::AssertValid() const
{
	CView::AssertValid();
}

void CGLView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGLView message handlers

int CGLView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here


	//Get device context	
	m_hDC=::GetDC(GetSafeHwnd());


	//Make a pixel format
	PIXELFORMATDESCRIPTOR pixelDesc;
	
	pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion = 1;
	
	pixelDesc.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL |
		PFD_DOUBLEBUFFER | PFD_STEREO_DONTCARE;
	
	pixelDesc.iPixelType = PFD_TYPE_RGBA;
	pixelDesc.cColorBits = 24;
	pixelDesc.cRedBits = 8;
	pixelDesc.cRedShift = 16;
	pixelDesc.cGreenBits = 8;
	pixelDesc.cGreenShift = 8;
	pixelDesc.cBlueBits = 8;
	pixelDesc.cBlueShift = 0;
	pixelDesc.cAlphaBits = 0;
	pixelDesc.cAlphaShift = 0;
	pixelDesc.cAccumBits = 64;
	pixelDesc.cAccumRedBits = 16;
	pixelDesc.cAccumGreenBits = 16;
	pixelDesc.cAccumBlueBits = 16;
	pixelDesc.cAccumAlphaBits = 0;
	pixelDesc.cDepthBits = 32;
	pixelDesc.cStencilBits = 32;
	pixelDesc.cAuxBuffers = 0;
	pixelDesc.iLayerType = PFD_MAIN_PLANE;
	pixelDesc.bReserved = 0;
	pixelDesc.dwLayerMask = 0;
	pixelDesc.dwVisibleMask = 0;
	pixelDesc.dwDamageMask = 0;

	int pixelformat=ChoosePixelFormat(m_hDC, &pixelDesc);

	if (pixelformat==0) {pixelformat=1;
	if (DescribePixelFormat(m_hDC,pixelformat,sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc)==0) return FALSE;
	}


    if (SetPixelFormat(m_hDC, pixelformat, &pixelDesc)==FALSE) return FALSE;

	//Create OPEN GL context
    m_hRC= wglCreateContext(m_hDC);
    if (m_hRC==NULL) return FALSE;
    if (wglMakeCurrent(m_hDC, m_hRC)==FALSE) return FALSE;


	return 0;
}

void CGLView::OnDestroy() 
{
	
	//Destory opengl context
    wglMakeCurrent(NULL,NULL);
    wglDeleteContext(m_hRC);
	::ReleaseDC( GetSafeHwnd(), m_hDC );


	CView::OnDestroy();
	

		
}

void CGLView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here 
	m_nViewX=cx;
	m_nViewY=cy;
	
	wglMakeCurrent(m_hDC, m_hRC);	
	double aspect_ratio;

    if (cy==0) return; 
    else aspect_ratio=((double) cx)/ ((double)cy);

    //viewport
	//bug is patched.
	//we set viewport both in front and back buffer
	//when we use only front buffer, it works fine
	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,cx,cy);
	glDrawBuffer(GL_BACK);


	//set viewport
	m_dViewX=cx, m_dViewY=cy;
	glGetIntegerv(GL_VIEWPORT, m_nVp);
 
	//make view volume
	KeepAspectRatio(aspect_ratio);
	//m_Camera.SetAspectRatio(aspect_ratio);
	SetViewVolume();

	//gl setting
    glDrawBuffer(GL_BACK);
    glEnable(GL_LIGHTING);
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_NORMALIZE);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glEnable(GL_CULL_FACE);

	//resize speed buffer
	ResizeSpeed();

	//clear view stack
	m_ViewStack.clear();
	m_iViewStack=NULL;
	
}

void CGLView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	//make current rendering context valid
	//wglMakeCurrent(m_hDC, m_hRC);
	//m_hDC=GetDC()->GetSafeHdc();
	wglMakeCurrent(m_hDC, m_hRC);

	//make viewport updated
	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,m_nViewX,m_nViewY);
	glDrawBuffer(GL_BACK);

	OnDraw(&dc);

	Draw2D();

	// swap buffers
	if (SwapBuffers(m_hDC)==FALSE) TRACE("cannot swap buffers");

	

	// Do not call CView::OnPaint() for painting messages
}


void CGLView::KeepAspectRatio(double a) 
{
	//2d
	m_dScreenWidth= m_dScreenHeight*a;

	//3d
	double height = m_fTop-m_fBottom;
    double width =  height*a; //control width from height
	double cenx=(m_fLeft+ m_fRight) / 2.;
	double ceny=(m_fTop+ m_fBottom) /2.;

	//Ŭ   
	m_fLeft=cenx - width/2.;
	m_fRight=cenx + width/2.;
	m_fTop = ceny + height/2.;
	m_fBottom= ceny - height/2.; 

	m_AspectRatio=a;
}

void CGLView::KeepAspectRatio(double& left, double& right,
							  double& bottom, double& top)
{
	//3d
	double height = top - bottom;
    double width =  height*m_AspectRatio; //control width from height
	double cenx=(left+ right) / 2.;
	double ceny=(top+ bottom) /2.;

	//Ŭ   
	left=cenx - width/2.;
	right=cenx + width/2.;
	top = ceny + height/2.;
	bottom= ceny - height/2.; 

}

void CGLView::SetViewVolume()
{
	//in case, there exist many OpenGL windows
	//this code should work
	wglMakeCurrent(m_hDC, m_hRC);	

	//projection mode
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	if (m_bPers) glFrustum(m_fLeft, m_fRight, m_fBottom, m_fTop, znear, zfar);
	else glOrtho(m_fLeft, m_fRight, m_fBottom, m_fTop, znear, zfar);

	glTranslated(0,0,-znear-m_Box*2);
	//copy projection matrix for 3d picking..
	glGetDoublev(GL_PROJECTION_MATRIX, m_projection);

    //model view mode
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}


void CGLView::SetLight()
{
	// Set the material color to follow the current color
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	//glColorMaterial(GL_FRONT_AND_BACK, GL_SPECULAR);
	//glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 100);
	glEnable(GL_COLOR_MATERIAL);


	float ambient[] = { 0.0, 0.0, 0.0, 0.0 };
	float diffuse[] = { 1.0, 1.0, 1.0, 0.0 };
    float specular[] = { 1.0, 1.0, 1.0, 0.0 };

    float position[] = { 10, 10, 10,  0 };
    float lmodel_ambient[] = { 0.7f, 0.7f, 0.7f, 0.0f };
    float local_view[] = { 0.0 };

    glEnable(GL_DEPTH_TEST);

    glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
    glLightfv(GL_LIGHT0, GL_POSITION, position);
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
    glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, local_view);

   
    glEnable(GL_LIGHT0);
	glDisable(GL_LIGHT1);
	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_LIGHT4);
	glDisable(GL_LIGHT5);
	glDisable(GL_LIGHT6);	
	glDisable(GL_LIGHT7);
	glEnable(GL_LIGHTING);
}

void CGLView::DrawScene()
{
	//initialize name stack
	glClearColor(1.0, 1.0, 1.0,0);
	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT | 
    GL_STENCIL_BUFFER_BIT);



	glPushMatrix();
	//lights..
	SetLight(); //fixed light
	glEnable(GL_COLOR_MATERIAL);
	
	glEnable(GL_LIGHT0);

	//screen rotation
	glColor3f(1,0,0);
	glRotated(m_DegX, 1, 0, 0); //second
	glRotated(m_DegY, 0, 1, 0); //first
	glutSolidSphere(2, 10,10);
	glPopMatrix();
	

}

BOOL CGLView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	return TRUE;	
//	return CView::OnEraseBkgnd(pDC);
}


void CGLView::MakeViewBox(double r)
{
	 //3d mode
	if (!m_bPers) { //isometric
	m_fLeft=-r; //dummy value
	m_fRight=r;
	m_fTop=r;//important
	m_fBottom=-r;
	znear=r; // 0 Ҽ ٰ  
	zfar=r*100;
	}
	else {
		m_fLeft=-r; //dummy value
		m_fRight=r;
		m_fTop=r/4.0;//important
		m_fBottom=-r/4.0;
		znear=r; // 0 Ҽ ٰ  
		zfar=r*100;
	}



	m_Box=r; // r    ִ 3   
	m_BoundR=r; //bounding sphere

	//for 2d screen
	m_dScreenWidth= 2*r;
	m_dScreenHeight=2*r;
}


void CGLView::DrawCaptureBox(CRect box)
{
	double Pro[16]; //projection matrix
	double Mod[16]; //modelview matrix 

	//backup matrix
	glGetDoublev(GL_PROJECTION_MATRIX, Pro); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, Mod); //get modelview matrix

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, m_dViewX, m_dViewY,0, -1000, 1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	//glprintf(0,24, "Z-Stamp");
	glColor3d(1,1,1);
	glBegin(GL_LINES);
	glVertex3d(box.left, box.top, 0);
	glVertex3d(box.left, box.bottom, 0);
	glVertex3d(box.right, box.bottom, 0);
	glVertex3d(box.right, box.top, 0);
	glEnd();



	//END
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	//RESTORE MATRIX
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixd(Pro);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd(Mod);


	glEnable(GL_LIGHTING);


}

void CGLView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	//viewing state 
	if (m_bViewing) {
		if (m_nCursorID==CURSOR_ROTATE) {
				m_DegX+= (point.y - m_OldPoint.y);
				m_DegY+= (point.x - m_OldPoint.x);

				//quaternion setup
				if (GetAsyncKeyState(VK_SHIFT)) {
					m_Rot=
						ROT_VIEW(VECTOR_VIEW(0,0,1), (point.y - m_OldPoint.y)/180.0*3.14159 )*
						m_Rot;
					
				}
				else {
					m_Rot = 
						
					ROT_VIEW(VECTOR_VIEW(1,0,0), (point.y - m_OldPoint.y)/180.0*3.14159 )*
					ROT_VIEW(VECTOR_VIEW(0,1,0), (point.x - m_OldPoint.x)/180.0*3.14159 )*
					
					m_Rot; // axis y
				}

				
			
				m_OldPoint=point;
		}
		if (m_nCursorID==CURSOR_PAN) {

			float cx,cy; //step
			float sx,sy; //scale

			//set scale
			ASSERT(m_dViewX>0 && m_dViewY>0);

			sx=(m_fRight - m_fLeft) / m_dViewX;
			sy=(m_fTop - m_fBottom) / m_dViewY;

			cx= (point.x - m_OldPoint.x)*sx;
			cy= (point.y - m_OldPoint.y)*sy;

			
			m_fLeft-=cx;//move the clipping place (lens)
			m_fRight-=cx;
			m_fTop+=cy;
			m_fBottom+=cy;
		
			SetViewVolume();
			m_OldPoint=point;
		}
		if (m_nCursorID==CURSOR_ZOOM) { //zoom
			float height=m_fTop - m_fBottom;
			float ceny= (m_fTop+ m_fBottom)/2.0f;

			if (point.y - m_OldPoint.y>0) {
				height*=0.95f;
			}
			else {
				height*=1.05f;
			}

			m_fTop= ceny + height/2.0f;
			m_fBottom= ceny - height/2.0f;
		

			KeepAspectRatio(m_AspectRatio); //keep aspect ratio
			SetViewVolume();
			m_OldPoint=point;

		}

		if (m_nCursorID==CURSOR_SECTIONZOOM) { //section zoom
			// save before update
			m_rectZoom2= m_rectZoom;
			// update m_rectZoom
			CRect& r=m_rectZoom;
			r.right=point.x;
			r.bottom=point.y;
			m_OldPoint=point;
			int x1,y1,x2,y2;
			CRect& box=m_rectZoom;
			CRect& box_old= m_rectZoom2;
			CDC* dc = GetDC();
			// tip : StockObject cannot be the xor pen, 2000.05.18
			dc->SetROP2( R2_XORPEN );

			CPen newpen(PS_SOLID,1,RGB(255,255,0));
			CPen* oldpen = dc->SelectObject( &newpen );
			dc->SelectObject( GetStockObject(HOLLOW_BRUSH) );

			// xor old one
			x1=box_old.left, y1= box_old.top;
			x2=box_old.right, y2= box_old.bottom;
			if (x1>x2) swap(x1,x2);
			if (y1>y2) swap(y1,y2);
			dc->Rectangle(x1,y1, x2,y2);

			// xor new one
			x1=box.left, y1= box.top;
			x2=box.right, y2= box.bottom;
			if (x1>x2) swap(x1,x2);
			if (y1>y2) swap(y1,y2);
			dc->Rectangle(x1,y1, x2,y2);
			dc->SelectObject( oldpen );
			ReleaseDC( dc ); 
		}

		
		m_bSpeedValid=false; // draw directly..
		//repaint screen
		// section zoom screen will be processed in child windows.
		if (m_nCursorID!=CURSOR_SECTIONZOOM) InvalidateRect(NULL);

	}
	
	
	CView::OnMouseMove(nFlags, point);
}

void CGLView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// mouse button contorl
	m_bLeftButton=true;


	
	//pan , zoom, rotate
	if (m_nCursorID== CURSOR_PAN || m_nCursorID == CURSOR_ZOOM ||
		m_nCursorID== CURSOR_ROTATE || m_nCursorID== CURSOR_SECTIONZOOM) {
			m_OldPoint=point;
			m_bViewing=TRUE; //viewing true

			//initialize
			if (m_nCursorID==CURSOR_SECTIONZOOM) {
				m_rectZoom2=m_rectZoom=CRect(point.x, point.y, point.x, point.y);
			} // end of small if

			// push view
			PushView();

	} // end of big if

	CView::OnLButtonDown(nFlags, point);
}


//3d picking
int  CGLView::SelectObject(int x, int y)
{
	//confirm rendering context
	wglMakeCurrent(m_hDC, m_hRC);

	//depth comparison
	GLuint depth= (GLuint) ~0;
	GLuint z1,z2;

	GLuint buffer[200]; //select buffer
	int hits, viewport[4];
	int chosen=NULL;

	glSelectBuffer(200,buffer); //set up the selction buffer
	glGetIntegerv(GL_VIEWPORT, viewport);

	TRACE("Gl Get Error %x \n",(int)glGetError());
		

	glRenderMode(GL_SELECT);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPickMatrix(x,viewport[3]-y,2, 2, viewport);
	glMultMatrixd(m_projection);
	glMatrixMode(GL_MODELVIEW);

	m_bPicking=true;
	DrawScene(); //select mode is true
	m_bPicking=false;
	hits=glRenderMode(GL_RENDER);


	if (hits<=0) TRACE("nothing is selected \n");
	else if (hits>=1) {
		int i;
		int p=0; //base pointer
		int number=0;

			BOOL GOT;

	   		for (i=0;i<hits;i++) {
			number=buffer[p]; 
			z1= buffer[p+1];
			z2= buffer[p+2];

			GOT=FALSE;
			if (z1<depth) {depth=z1;GOT=TRUE;}
			if (z2<depth) {depth=z2;GOT=TRUE;}

			p+= 2 + number ;
			if (GOT) chosen=buffer[p];			
				
			p++; //move to the next hit list
			}




		//buffer [0]: number of names in the name stack
		//buffer [1]: minimum z , [2]: maximum z, 
		//buffer [3] : 1st chosen number
		//buffer [4]: 2nd chosen  [5]: 3rd chosen ..etc.. ->
		//int name_number=buffer[0];
		//int id=buffer [ (name_number-1) + 3 ] ;
		//char scr[100];
		//sprintf(scr,"number %d \n",id );
		//afxDump<<scr<<'\n';
		//chosen=id; // id Ͽ 
	} //end of else


	// ȭ  
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMultMatrixd(m_projection);
	glMatrixMode(GL_MODELVIEW);

	return chosen;

}

//3d picking
int CGLView::SelectObjects(int sx, int sy,int ex,int ey, CHOSEN_LIST& List )
{
	//confirm rendering context
	wglMakeCurrent(m_hDC, m_hRC);

	//depth comparison
	GLuint depth= (GLuint) ~0;
	GLuint z1,z2;

	static GLuint buffer[20000]; //select buffer
	int hits, viewport[4];
	int chosen=NULL;

	glSelectBuffer(20000,buffer); //set up the selction buffer
	glGetIntegerv(GL_VIEWPORT, viewport);

	TRACE("Gl Get Error %x \n",(int)glGetError());
		

	glRenderMode(GL_SELECT);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	//size
	double sizex=ex-sx; 
	double sizey=ey-sy;
	double cx=sx+sizex/2.0;
	double cy=sy+sizey/2.0;

	// center x, center y, width, height
	// bug fixed!
	gluPickMatrix(cx,viewport[3]-cy, sizex, sizey, viewport);
	glMultMatrixd(m_projection);
	glMatrixMode(GL_MODELVIEW);

	m_bPicking=true;
	DrawScene(); //select mode is true
	m_bPicking=false;
	hits=glRenderMode(GL_RENDER);


	if (hits<=0) TRACE("nothing is selected \n");
	else if (hits>=1) {
		int i;
		int p=0; //base pointer
		int number=0;

			BOOL GOT;

	   		for (i=0;i<hits;i++) {
				
			

			number=buffer[p]; p++;
			z1= buffer[p];p++;
			z2= buffer[p];p++;

			GOT=FALSE;
			if (z1<depth) {depth=z1;GOT=TRUE;}
			if (z2<depth) {depth=z2;GOT=TRUE;}

			//add
			{
				int i;
				for(i=0;i<number;i++)
				{
					List.push_back(buffer[p]);p++;
				}
			}


			if (GOT) chosen=buffer[p-1];	
			
			}




		//buffer [0]: number of names in the name stack
		//buffer [1]: minimum z , [2]: maximum z, 
		//buffer [3] : 1st chosen number
		//buffer [4]: 2nd chosen  [5]: 3rd chosen ..etc.. ->
		//int name_number=buffer[0];
		//int id=buffer [ (name_number-1) + 3 ] ;
		//char scr[100];
		//sprintf(scr,"number %d \n",id );
		//afxDump<<scr<<'\n';
		//chosen=id; // id Ͽ 
	} //end of else


	// ȭ  
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMultMatrixd(m_projection);
	glMatrixMode(GL_MODELVIEW);

	return chosen;

}

void CGLView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// mouse button contorl
	m_bLeftButton=false;


	//confirm OpenGL binding
	wglMakeCurrent(m_hDC, m_hRC);


	if (m_nCursorID==CURSOR_SECTIONZOOM) {
			// make valid..
			CRect& r=m_rectZoom;
			if (r.left>r.right) swap(r.left, r.right);
			if (r.top> r.bottom) swap(r.top, r.bottom);

		if (m_rectZoom.Width()>2 && m_rectZoom.Height()>2 ) { //magnify
			float sx,sy; //scale

			float left,top; //left , top
			float right, bottom; //right , bottom

			//new values
			float left2, right2, bottom2, top2;
			

			//set scale
			ASSERT(m_dViewX>0 && m_dViewY>0);

			sx=(m_fRight - m_fLeft) / (float)m_dViewX;
			sy=(m_fTop - m_fBottom) / (float)m_dViewY;

			//left top is the basis
			left=m_rectZoom.left*sx;
			right=m_rectZoom.right*sx;
			top=m_rectZoom.top*sy;
			bottom=m_rectZoom.bottom*sy;

			left2=m_fLeft+left;
			right2=m_fLeft+right;
			top2=m_fTop - top;
			bottom2 = m_fTop -bottom;

			//done.. copy
			m_fLeft=left2;
			m_fRight=right2;
			m_fTop= top2;
			m_fBottom= bottom2;

			KeepAspectRatio(m_AspectRatio); //keep aspect ratio
			SetViewVolume();
		} //magnify

	
	} //end of IDM_SECTIONZOOM

	//update screen

/*	if (m_nCursorID== CURSOR_PAN || m_nCursorID == CURSOR_ZOOM ||
		m_nCursorID== CURSOR_ROTATE || m_nCursorID== CURSOR_SECTIONZOOM)
	{
		InvalidateRect(NULL);   
	}*/

	// end viewing
	if (m_bViewing) {
		m_bViewing=FALSE;

		m_bSpeedValid=false; // draw directly
		InvalidateRect(NULL);

	}


	CView::OnLButtonUp(nFlags, point);
}


//draw grid lines
void  CGLView::DrawNet(double xsize, double zsize, double xstep, double zstep)
{
	glDisable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL);

	double c0[3]={0.6, 0.6, 0.6};
	double c1[3]={0.3, 0.3, 0.3};
	double c2[3]={0, 0, 0};

	DrawNet2(xsize, zsize, xstep, zstep,c0,c1,c2);

	glEnable(GL_LIGHTING);
}


//this is for sophisticated material setting
//use color3d or color4d instead of this
void  CGLView::SetMaterial(double r, double g, double b)
{
	float no_mat[] = { 0.0, 0.0, 0.0, 1.0 };
    float mat_ambient[] = { (float)r, (float)g, (float)b, 1.0 };
    float mat_ambient_color[] = { 0.8f, 0.8f, 0.2f, 1.0f };
    float mat_diffuse[] = { (float)r, (float)g, (float)b, 1.0f };
    float mat_specular[] = { 1.0f, 1.0f, 1.0f, 1.0f };
    float no_shininess[] = { 0.0f };
    float low_shininess[] = { 5.0f };
    float high_shininess[] = { 120.0f };
    float mat_emission[] = {0.3f, 0.2f, 0.2f, 0.0f};
                                                 

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, mat_ambient);
    glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, mat_diffuse);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, mat_specular);
    glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, high_shininess);
    glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, no_mat);

}

//print output
void CGLView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	CRect rect;
	GetClientRect(&rect);

	//wglMakeCurrent(m_hDC, m_hRC);
	wglMakeCurrent(m_hDC, m_hRC);
	//make viewport updated
    glViewport(0,0,m_nViewX,m_nViewY);
	DrawScene();
	// swap buffers
	if (SwapBuffers(m_hDC)==FALSE) TRACE("cannot swap buffers");


	CClientDC wnd(this);
	
	pDC->BitBlt(0,0, rect.Width(), rect.Height(), &wnd, 0, 0, SRCCOPY);


}


//make sure that current OpenGL context is connected to current GDI rendering context
void  CGLView::GetCurrent(HDC& hDC, HGLRC& hRC) 
{
	hDC = wglGetCurrentDC();
	hRC = wglGetCurrentContext(); 
} 

BOOL  CGLView::SetCurrent(HDC hDC, HGLRC hRC) 
{
	if (wglMakeCurrent(hDC, hRC) == FALSE)
		return FALSE;
	return TRUE;
} 





BOOL CGLView::SetMemDcPixelFormat(HDC hMemDC)
{
	int nGLPixelIndex;

	PIXELFORMATDESCRIPTOR pixelMem;
	pixelMem.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelMem.nVersion = 1;
	
	pixelMem.dwFlags = PFD_DRAW_TO_BITMAP | PFD_SUPPORT_OPENGL |
		PFD_STEREO_DONTCARE;
	
	pixelMem.iPixelType = PFD_TYPE_RGBA;
	pixelMem.cColorBits = 24;
	pixelMem.cRedBits = 8;
	pixelMem.cRedShift = 16;
	pixelMem.cGreenBits = 8;
	pixelMem.cGreenShift = 8;
	pixelMem.cBlueBits = 8;
	pixelMem.cBlueShift = 0;
	pixelMem.cAlphaBits = 0;
	pixelMem.cAlphaShift = 0;
	pixelMem.cAccumBits = 64;
	pixelMem.cAccumRedBits = 16;
	pixelMem.cAccumGreenBits = 16;
	pixelMem.cAccumBlueBits = 16;
	pixelMem.cAccumAlphaBits = 0;
	pixelMem.cDepthBits = 32;
	pixelMem.cStencilBits = 32;
	pixelMem.cAuxBuffers = 0;
	pixelMem.iLayerType = PFD_MAIN_PLANE;
	pixelMem.bReserved = 0;
	pixelMem.dwLayerMask = 0;
	pixelMem.dwVisibleMask = 0;
	pixelMem.dwDamageMask = 0;

	nGLPixelIndex = ChoosePixelFormat(hMemDC, &pixelMem);
	if (nGLPixelIndex == 0) // Choose default
	{
		nGLPixelIndex = 1;
		if (DescribePixelFormat(hMemDC, nGLPixelIndex, 
			sizeof(PIXELFORMATDESCRIPTOR), &pixelMem))
			return FALSE;
	}

	if (!SetPixelFormat(hMemDC, nGLPixelIndex, &pixelMem))
		return FALSE;

	return TRUE;
}



void CGLView::DrawAxis(double height)
{
	float rate=0.7f; //cylinder rate
	float size=height*rate;

	float radius=height/20.0;
	float cone_radius=radius*2;
	float cone_size= height*(1-rate);
	float letter_radius=radius/2.0;
	float letter_scale=radius/10.0;



	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	//z axis
	glPushMatrix();
	glColor3f(0,0,1);
	gluCylinder(obj,radius, radius, size, 12, 1); //obj , base, top, height 
	glTranslated(0,0,size);
	gluCylinder(obj,cone_radius, 0, cone_size, 12, 1);
	//letter Z
	glTranslated(0,0,cone_size);
	glScaled(0.1, 0.1, 0.1);
	glRotated(180, 0, 0, 1);

	glPopMatrix();

	//x axis
	glPushMatrix();
	glColor3f(1,0,0);
	glRotated(90, 0, 1, 0);
	gluCylinder(obj,radius, radius, size, 12, 1); //obj , base, top, height 
	glTranslated(0,0,size);
	gluCylinder(obj,cone_radius, 0, cone_size, 12, 1);
	//letter X
	glTranslated(0,0,cone_size);
	glScaled(0.1, 0.1, 0.1);
	glPopMatrix();

	//y axis
	glPushMatrix();
	glColor3f(0,1,0);
	glRotated(-90, 1, 0, 0);
	gluCylinder(obj,radius, radius, size, 12, 1); //obj , base, top, height 
	glTranslated(0,0,size);
	gluCylinder(obj,cone_radius, 0, cone_size, 12, 1);
	//letter Y
	glTranslated(0,0,cone_size);
	glScaled(0.1, 0.1, 0.1);
	
	glPopMatrix();

	gluDeleteQuadric(obj);
}

void CGLView::OnSetFocus(CWnd* pOldWnd) 
{
	CView::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here
	wglMakeCurrent(m_hDC, m_hRC);	
}

//get rendering context
HGLRC CGLView::GetRC(void)
{
	return m_hRC;
}


void CGLView::ChangeCursor(int c)
{
	m_nCursorID=c;

}

void CGLView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	ChangeCursor(CURSOR_ARROW);
	CView::OnRButtonDown(nFlags, point);
}

void CGLView::OnViewPan() 
{
	if (m_nCursorID==CURSOR_PAN) m_nCursorID=CURSOR_ARROW;
	else ChangeCursor(CURSOR_PAN);	
}

void CGLView::OnViewRotate() 
{
	if (m_nCursorID==CURSOR_ROTATE) m_nCursorID=CURSOR_ARROW;
	else ChangeCursor(CURSOR_ROTATE);
}

void CGLView::OnViewZoom() 
{
	if (m_nCursorID==CURSOR_ZOOM) m_nCursorID=CURSOR_ARROW;
	else ChangeCursor(CURSOR_ZOOM);
}

void CGLView::OnViewExtents() 
{
	// TODO: Add your command handler code here
	MakeViewBox(m_BoundR);
	//m_DegX=0.0, m_DegY=0.0; //screen camera  sin ^2 theta x = 1 / square(2)
	KeepAspectRatio(m_AspectRatio);
	SetViewVolume();

	m_bSpeedValid=false;
	InvalidateRect(NULL);
}

void CGLView::OnViewX() 
{
	// TODO: Add your command handler code here
	m_DegX=0.0f;
	m_DegY=90.0f;
	m_Rot=ROT_VIEW(VECTOR_VIEW(0,1,0),RAD(-90.0));
	InvalidateRect(NULL);
}

void CGLView::OnViewY() 
{
	// TODO: Add your command handler code here
	m_DegX=90.0f;
	m_DegY=0.0f;
	m_Rot=ROT_VIEW(VECTOR_VIEW(1,0,0), RAD(90));
	InvalidateRect(NULL);
}

void CGLView::OnViewZ() 
{
	// TODO: Add your command handler code here
	m_DegX=0.0f;
	m_DegY=0.0f;
	m_Rot=ROT_VIEW(VECTOR_VIEW(1,0,0), 0);
	InvalidateRect(NULL);
}


//opengl print
void CGLView::glprintf2(char* fmt, ...) {
	char buffer[200];
	va_list argptr;
	int cnt;

	//analyze
	va_start(argptr, fmt);
	cnt=vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	char *p;
	for (p = buffer; *p; p++)
	glutStrokeCharacter(GLUT_STROKE_ROMAN, *p);
}
int CGLView::glGetWidth(char* fmt, ...) {
	char buffer[200];
	va_list argptr;
	int cnt;

	//analyze
	va_start(argptr, fmt);
	cnt=vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	char *p;
	int width=0;

	for (p = buffer; *p; p++) {
	width+=glutStrokeWidth(GLUT_STROKE_ROMAN, *p);
	}

	return width;
}

void CGLView::OnViewSectionzoom() 
{
	if (m_nCursorID==CURSOR_SECTIONZOOM) m_nCursorID=CURSOR_ARROW;
	else ChangeCursor(CURSOR_SECTIONZOOM);	
}

//perspective
void CGLView::OnViewPers() 
{
	// TODO: Add your command handler code here
	m_bPers = ! m_bPers;	
	MakeViewBox(m_BoundR); //make view box by Bounding Sphere
	KeepAspectRatio(m_AspectRatio);//control aspect ratio
	//m_Camera.SetAspectRatio(aspect_ratio);
	SetViewVolume();
	InvalidateRect(NULL);
}

void CGLView::OnUpdateViewPers(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_bPers);	
}

void CGLView::OnUpdateViewZoom(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_nCursorID==CURSOR_ZOOM);	
}


void CGLView::OnUpdateViewSectionzoom(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_nCursorID==CURSOR_SECTIONZOOM);
}


void CGLView::OnUpdateViewRotate(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_nCursorID==CURSOR_ROTATE);
}

void CGLView::OnUpdateViewPan(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	pCmdUI->SetRadio(m_nCursorID==CURSOR_PAN);	
}



BOOL CGLView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// change cursor ? 
	if (!m_bChangeCursor) return true;

	HCURSOR hCursor;


	/*switch(m_nCursorID) {
	case CURSOR_PAN: hCursor=AfxGetApp()->LoadCursor(IDC_PAN);break;
	case CURSOR_ZOOM:hCursor=AfxGetApp()->LoadCursor(IDC_ZOOM);break;
	case CURSOR_ROTATE:hCursor=AfxGetApp()->LoadCursor(IDC_ROTATE);break;
	case CURSOR_SECTIONZOOM: hCursor=AfxGetApp()->LoadCursor(IDC_SECTIONZOOM);break;

	case CURSOR_ARROW:	hCursor=AfxGetApp()->LoadStandardCursor(MAKEINTRESOURCE(IDC_ARROW));break;
	case CURSOR_HELP:hCursor=AfxGetApp()->LoadStandardCursor(MAKEINTRESOURCE(IDC_HELP));break;
	case CURSOR_WAIT:hCursor=AfxGetApp()->LoadStandardCursor(MAKEINTRESOURCE(IDC_WAIT));break;
	
	}*/

	SetCursor(hCursor);

	
	return CView::OnSetCursor(pWnd, nHitTest, message);
	//return TRUE;
}

//make a new boudning box 
// x, y, z!
void CGLView::SetBoundingBox(double sx, double sy, double sz)
{
	//find max value
	//make plus value
	sx= fabs(sx);
	sy= fabs(sy);
	sz= fabs(sz);

	//compare
	double r=sx;
	if (sy>r) r=sy;
	if (sz>r) r=sz;

	//set bounding box value
	m_BoundX=sx;
	m_BoundY=sy;
	m_BoundZ=sz;

	MakeViewBox(r);
	
	KeepAspectRatio(m_AspectRatio);
	SetViewVolume();
}

int CGLView::IsCursorIdle(void)
{
	if (m_nCursorID == CURSOR_ARROW) return true;
	else return false;
}

//draw bitmap text
void CGLView::glprintf(double x, double y,char* fmt, ...) {
	char buffer[200];
	//setup
	buffer[0]=NULL;
	va_list argptr;
	int cnt;

	//analyze
	va_start(argptr, fmt);
	cnt=vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	//draw
	int len, i;
	void *font = GLUT_BITMAP_HELVETICA_18;

	glRasterPos2f(x, y);
	len = (int) strlen(buffer);
	for (i = 0; i < len; i++) {
		glutBitmapCharacter(font, buffer[i]);
	}
}

//draw bitmap text
void CGLView::glprintf(void* FONT, double x, double y,char* fmt, ...) {
	char buffer[200];
	//setup
	buffer[0]=NULL;
	va_list argptr;
	int cnt;

	//analyze
	va_start(argptr, fmt);
	cnt=vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	//draw
	int len, i;
	void *font = FONT;

	glRasterPos2f(x, y);
	len = (int) strlen(buffer);
	for (i = 0; i < len; i++) {
		glutBitmapCharacter(font, buffer[i]);
	}
}

//DEL void CGLView::SetupMatrix()
//DEL {
//DEL 
//DEL }

//DEL void CGLView::RestoreMatrix()
//DEL {
//DEL 	
//DEL }

void CGLView::DrawAxis2(double height)
{
	double height2= height*0.5;
	double base=height2*0.1;
	
	//begin
	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	glColor4d(1,1,0,0.2);
	glutSolidCube(base*2);

	//draw Z
	glColor4d(0,0,1,0.2);
	glPushMatrix();
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw Y
	glColor4d(0,1,0,0.2);
	glPushMatrix();
	glRotated(90, -1, 0, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw X
	glColor4d(1,0,0,0.2);
	glPushMatrix();
	glRotated(90, 0, 1, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();


	gluDeleteQuadric(obj);
	//end

}

bool CGLView::Get3D(int wx, int wy, double& objx, double& objy, double& objz,double Pro[16], double Mod[16])
{

	static GLfloat f[50];

	int px=wx;
	int py=(int)m_dViewY - wy;

	//The glReadPixels function returns values from each pixel with lower-left corner 
	//at (x + i, y + j) for 0  i < width and 0  j < height. 
	//This pixel is said to be the ith pixel in the jth row. 
	//Pixels are returned in row order from the lowest to the highest row, 
	//left to right in each row.

	glReadPixels(px , py, 1,1, GL_DEPTH_COMPONENT ,
		GL_FLOAT, f);

	//sort
	double zdepth=0.0;
	zdepth=f[0];
		
	if (zdepth==0.0 || zdepth==1.0) return false;

	double winx,winy,winz;
	winx= px;
	winy= py;
	winz= zdepth; //0.0 <- near plane, 1.0 <- far plane

	glGetIntegerv(GL_VIEWPORT, m_nVp);
 
	//get object point

	gluUnProject(winx, winy, winz, Mod, Pro, m_nVp, 
		&objx, &objy, &objz);

	return true;
}

void CGLView::UpdateCenter()
{

}

//draw basic grids
// no color material setting here
void CGLView::DrawNet2(double xsize, double zsize, double xstep, double zstep,
					   double color[3], // small
					   double color2[3], // middle
					   double color3[3]) //big
{

	//adjust xsize , zsize
	if (xstep<0.0000001 || zstep<0.0000001) return; //avoid too small grid
	int countx= (int)xsize/xstep;
	int countz= (int)zsize/zstep;

	//okay
	xsize= (double)countx * xstep;
	zsize= (double)countz * zstep;



	glPushMatrix();

	double x,z;
	
	//main line
	//glDisable(GL_LINE_STIPPLE);
	int c=0;
	glLineWidth(2);
	// middle
	glColor3dv(color2);
	c=0;
	for (x=0; x<=xsize; x+=xstep) {
		if ( c++%5 == 0 ) {
			glLineWidth(2);
			glColor3dv(color2);
		}
		else {
			glLineWidth(1);
			glColor3dv(color);
		}
			glBegin(GL_LINES);
		glVertex3d(x, 0, -zsize);
		glVertex3d(x, 0,  zsize);
		glEnd();
		
	}

	c=0;
	for (x=0; x>=-xsize; x-=xstep) {
			if ( c++%5 == 0 ) {
			glLineWidth(2);
			glColor3dv(color2);
		}
		else {
			glLineWidth(1);
			glColor3dv(color);
		}
			glBegin(GL_LINES);
		glVertex3d(x, 0, -zsize);
		glVertex3d(x, 0,  zsize);
		glEnd();
	}

	c=0;
	for (z=0; z<=zsize; z+=zstep) {
			if ( c++%5 == 0 ) {
			glLineWidth(2);
			glColor3dv(color2);
		}
		else {
			glLineWidth(1);
			glColor3dv(color);
		}
		glBegin(GL_LINES);
		glVertex3d(-xsize, 0, z);
		glVertex3d( xsize, 0, z);
		glEnd();
	}
	
	c=0;
	for (z=0; z>=-zsize; z-=zstep) {
		if ( c++%5 == 0 ) {
			glLineWidth(2);
			glColor3dv(color2);
		}
		else {
			glLineWidth(1);
			glColor3dv(color);
		}
		glBegin(GL_LINES);
		glVertex3d(-xsize, 0, z);
		glVertex3d( xsize, 0, z);
		glEnd();
	}




	//major line
	glLineWidth(3);
	// big
	glColor3dv(color3);
	glBegin(GL_LINES);
	glVertex3d(0, 0, -zsize);
	glVertex3d(0, 0,  zsize);
	glVertex3d(-xsize, 0, 0);
	glVertex3d( xsize, 0, 0);
	glLineWidth(1);

	glEnd();
	
	
	glPopMatrix();	

}

void CGLView::print2(int loc, double scale, double x, double y,double z,char* fmt, ...) {

	char buffer[200];
	//setup
	buffer[0]=NULL;
	va_list argptr;
	int cnt;

	//analyze
	va_start(argptr, fmt);
	cnt=vsprintf(buffer, fmt, argptr);
	va_end(argptr);

	//draw
	int len, i;


	glPushMatrix();
	glTranslated(x,y,z);
	
	glScaled(scale, scale, scale);


	len = (int) strlen(buffer);

	//make it located on the center
	double wi;
	
	wi=0;
	for (i = 0; i < len; i++) {
		wi +=glutStrokeWidth(GLUT_STROKE_ROMAN, buffer[i]);
	}
	if (loc<0) glTranslated(-wi, 0, 0);
	else if(loc==0) glTranslated(-wi/2.0,0,0);

	
	//write
	for (i = 0; i < len; i++) {
	
		glutStrokeCharacter(GLUT_STROKE_ROMAN, buffer[i]);
	}
	glPopMatrix();
}


//called from constructor or any module which want reinitialize
//the view
void CGLView::ResetupData()
{
	m_DegX=35.26, m_DegY=-45; //screen camera  sin ^2 theta x = 1 / square(2)
	//read data
	m_bPers=AfxGetApp()->GetProfileInt("Settings", "Perspective", 1); //perspective ? 

	m_bViewing=FALSE; //viewing mode?
	m_bPicking=false; //picking mode?

	m_nCursorID = CURSOR_ARROW;//default cursor

	//quaternion
	m_Rot=ROT_VIEW(VECTOR_VIEW(0,1,0), 0);
}

//if there are numerous OpenGL screens in MDI program
//we need to confirm rendering context before using OpenGL commands
void CGLView::ConfirmRC()
{
	 wglMakeCurrent(m_hDC, m_hRC);

}

//get projection and modelview matrix
void CGLView::GetMat(double Pro[], double Mod[])
{
	//copy matrix here
	memcpy(Pro, m_dPro, sizeof(double)*16);
	memcpy(Mod, m_dMod, sizeof(double)*16);
}

void CGLView::Draw2D()
{
	if (m_bPicking) return; // picking state? don't bother ..

	// draw in front buffer
	glDrawBuffer(GL_FRONT);


	double Pro[16]; //projection matrix
	double Mod[16]; //modelview matrix 

	//backup matrix
	glGetDoublev(GL_PROJECTION_MATRIX, Pro); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, Mod); //get modelview matrix

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, m_dViewX, m_dViewY,0, -1000, 1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	
	//glprintf(0,24, "Z-Stamp");
	if (m_nCursorID==CURSOR_SECTIONZOOM && m_bLeftButton) {
		CRect& box=m_rectZoom;

		//glColor3d(1,1,1);
		glColor4dv(m_dvTextColor);
			      
		glColor3d(1,0.5,0);
		glEnable(GL_LINE_STIPPLE);
		glLineWidth(2);
		glLineStipple (1, 0x3333);  /*  dotted  */
		glBegin(GL_LINE_LOOP);
		glVertex3d(box.left, box.top, 0);
		glVertex3d(box.left, box.bottom, 0);
		glVertex3d(box.right, box.bottom, 0);
		glVertex3d(box.right, box.top, 0);
		glEnd();
		glDisable(GL_LINE_STIPPLE);
	}



	//END
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	//RESTORE MATRIX
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixd(Pro);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd(Mod);


	glEnable(GL_LIGHTING);

	// back to backbuffer
	glDrawBuffer(GL_BACK);
}

// connect GL context and window
void CGLView::ActivateRC()
{
	wglMakeCurrent(m_hDC, m_hRC);
}
  
// save OpenGL back buffer to the disk directly
void CGLView::SaveBitmap(char* name) throw(char*)
{
	glReadBuffer(GL_BACK); // designate buffer to read

	int vp[4];
	glGetIntegerv(GL_VIEWPORT, vp);
	char* buffer=NULL;   
	int width=vp[2]; 
	int height=vp[3]; 
	int size=(width+1)*(height+1)*3;

	// get memory
	buffer=new char[size]; // Red , Green , Blue -> RGB
	if (buffer==NULL) throw "memory cannot be gained";

	// read pixels to buffer
	// GL_BGR_EXT has compatibility problem.
	// so use GL_RGB
	// swap Red, Blue values..

	// problem code
	// FIRE GL 1000 Pro works very well, though
	//glReadPixels(0,0, width, height, GL_BGR_EXT, GL_UNSIGNED_BYTE, buffer);

	// standard code
	int i;
	glReadPixels(0,0, width, height, GL_RGB, GL_UNSIGNED_BYTE, buffer);
	for (i=0;i<size;i+=3) {
		swap(*(buffer+i), *(buffer+i+2));
	}
	




	// write to disk

	FILE* file=fopen(name, "wb");
	if (file==NULL) throw "Cannot open file to save bitmap!";

	// write header
	BITMAPFILEHEADER	hdr; // file header
	BITMAPINFOHEADER	bi;  // info header
	// set up info header
	bi.biSize		= sizeof(BITMAPINFOHEADER);
	bi.biWidth		= width;
	bi.biHeight 		= height;
	bi.biPlanes 		= 1;
	bi.biBitCount		= 24;
	bi.biCompression	= BI_RGB;
	bi.biSizeImage		= 0;
	bi.biXPelsPerMeter	= 0;
	bi.biYPelsPerMeter	= 0;
	bi.biClrUsed		= 0;
	bi.biClrImportant	= 0;

	// set up file header
	hdr.bfType		= ((WORD) ('M' << 8) | 'B');	// is always "BM"
	hdr.bfSize		=  sizeof( hdr ) + sizeof(bi) + size;
	hdr.bfReserved1 	= 0;
	hdr.bfReserved2 	= 0;
	hdr.bfOffBits		= (DWORD) (sizeof( hdr ) + bi.biSize );

	// write to disk
	fwrite(&hdr, sizeof(hdr), 1, file); // file header
	fwrite(&bi, sizeof(bi), 1, file); // info header

	// write body

	for (i=0;i<size;i++)
	fputc(buffer[i], file);
	TRACE("Wrote %d Characters to \"%s\"\n", size, name);
	fclose(file);

	// free memory
	delete buffer;
}

///////////////////////////////////////////////////////////////////////////////////////
//         SPEED BUFFER 
void CGLView::InitSpeed(void)
{
	m_bSpeed=false; 
	m_pSpeedBuffer=NULL; // buffer to save opengl backbuffer
	m_bSpeedValid=false; 
	// speed screen specification
	m_nSpeedWidth=0;
	m_nSpeedHeight=0;
}
void CGLView::ResizeSpeed(void)
{
	if (!m_bSpeed) return;
	m_bSpeedValid=false;


	int vp[4];
	glGetIntegerv(GL_VIEWPORT, vp);
	m_nSpeedWidth=vp[2]; 
	m_nSpeedHeight=vp[3]; 

	int size=(m_nSpeedWidth+1)*(m_nSpeedHeight+1)*4;

	// get memory
	if (m_pSpeedBuffer) delete m_pSpeedBuffer;

	m_pSpeedBuffer=new unsigned char[size]; // Red , Green , Blue -> RGB
	if (m_pSpeedBuffer==NULL) throw "memory cannot be gained";

}
void CGLView::SaveSpeed(void)
{
	if (!m_bSpeed || m_bPicking) return;

	// save OpenGL screen to buffer
	glReadBuffer(GL_BACK); // designate buffer to read

	// standard code
	glReadPixels(0,0, m_nSpeedWidth, m_nSpeedHeight, GL_RGBA, GL_UNSIGNED_BYTE, m_pSpeedBuffer);

	// valid!
	m_bSpeedValid=true; // LoadSpeed is valid
}
void CGLView::LoadSpeed(void)
{
	if (!m_bSpeed || !m_bSpeedValid || m_bPicking) return;


	double Pro[16]; //projection matrix
	double Mod[16]; //modelview matrix 
	//backup matrix
	glGetDoublev(GL_PROJECTION_MATRIX, Pro); //get projection matrix
	glGetDoublev(GL_MODELVIEW_MATRIX, Mod); //get modelview matrix

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0, m_dViewX, 0,m_dViewY, -1000, 1000);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();


	glDrawBuffer(GL_BACK);

	//initialize name stack
//	glClearColor(1.0, 1.0, 1.0,0);

	glDisable(GL_DEPTH_TEST);
	glRasterPos2i(0,0);
	glDrawPixels(m_nSpeedWidth, m_nSpeedHeight, GL_RGBA, GL_UNSIGNED_BYTE, m_pSpeedBuffer);
	glEnable(GL_DEPTH_TEST);

	// swap buffers
//	if (SwapBuffers(m_hDC)==FALSE) TRACE("cannot swap buffers");

	// restore matrix
	//RESTORE MATRIX
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixd(Pro);
	glMatrixMode(GL_MODELVIEW);
	glLoadMatrixd(Mod);


}


// view manipulation
// actually, m_ViewStack's structure isn't stack,
// rather deque, but we call this as stack ;)
void CGLView::PushView()
{
	// delete first
	if (m_iViewStack!=NULL && m_iViewStack!=m_ViewStack.end()) {
		m_ViewStack.erase(m_iViewStack, m_ViewStack.end());		

	}

	m_ViewStack.push_back(CViewNode());
	CViewNode& node=m_ViewStack.back();

	node.m_DegX=m_DegX;
	node.m_DegY=m_DegY;
	node.m_Rot=m_Rot;
	node.m_fBottom= m_fBottom;
	node.m_fTop= m_fTop;
	node.m_fLeft= m_fLeft;
	node.m_fRight = m_fRight;
	node.zfar = zfar;
	node.znear = znear;

	// over flow?
	if (m_ViewStack.size()>MAX_VIEW_STACK) {
		m_ViewStack.pop_front(); // delete oldest one
	} // end of if


	// set iterator
	m_iViewStack= m_ViewStack.end()--;

}

void CGLView::PopView()
{
	if (m_ViewStack.empty()) return; // nothing to read

	CViewNode& node=m_ViewStack.back();
	ReadViewNode(node);
	

	// delete  
	m_ViewStack.pop_back();
}

int CGLView::NextView()
{
	CViewNodes::iterator tmp=m_iViewStack;
	tmp++;

	if (tmp==m_ViewStack.end()) 
	if (m_ViewStack.empty() || tmp==m_ViewStack.end()) return false;

	m_iViewStack++;

	ReadViewNode(*m_iViewStack);

	// okay update screen
	return true;
	
}

int CGLView::PreviousView()
{

	if (m_ViewStack.empty() || m_iViewStack==m_ViewStack.begin()) return false;

	m_iViewStack--;
	ReadViewNode(*m_iViewStack);

	// okay update screen
	return true;
}

void CGLView::ReadViewNode(CViewNode& node)
{
	// load
	m_DegX=	node.m_DegX		;
	m_DegY=	node.m_DegY		;
	m_Rot= node.m_Rot;
	m_fBottom=	node.m_fBottom	;
	m_fTop=	node.m_fTop		;
	m_fLeft=	node.m_fLeft;	
	m_fRight=	node.m_fRight;	
	zfar=	node.zfar		;
	znear=	node.znear		;

}
